INTERFACE SplitStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;


TYPE
  Array = ARRAY OF IO.Stream;


PROCEDURE Open(
    READONLY streams: Array;
    unbuffered := FALSE;
    name := "split")
    : IO.Stream
    RAISES {IO.Error};
(* Creates a write only "split stream". Put operations to this stream are sent
to all the streams in the 'streams' array. The streams in the 'streams' array
are called the "sub streams" of the split stream.
  'Open' will raise 'Error' if any member of 'streams' is unusable or is not
writable.
  The split stream is unbuffered if any of its sub streams are unbuffered and
is line buffered if any of its sub streams are line buffered.
  When a split stream flushes to its sub streams it locks each sub stream in
turn and flushes to it. If a stream error occurs on a sub stream it is caught
and propagated to the split stream; flushes to other sub streams may be lost.
  The only effect of closing a split stream is to flush out any buffered data
to the sub streams; the sub streams are not closed.
  If the 'unbuffered' flag is given to 'Open' the resulting split stream will
be unbuffered (i.e. it will be flushed after every put operation). This could
be useful if a sub stream is going to be used separately during the lifetime
of the split stream; it allows the user to control the order of data put via
the split stream and data put directly to the sub stream. *)

END SplitStream.
