UNSAFE MODULE Stream_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT IO_impl;
IMPORT Unix, Uuio, Uerror, UnixMutex, OSError_ux;


PROCEDURE Flush(s: T; READONLY chars: ARRAY OF CHAR): BOOLEAN RAISES {} =
  BEGIN
    LOCK UnixMutex.errno DO
      IF Uuio.write(s.d, ADR(chars[0]), NUMBER(chars)) < 0 THEN
        s.rc := Uerror.errno;
        RETURN FALSE;
      ELSE
        RETURN TRUE;
      END;
    END;
  END Flush;


PROCEDURE Fill(s: T; VAR chars: ARRAY OF CHAR): INTEGER RAISES {} =
  BEGIN
    LOCK UnixMutex.errno DO
      WITH charsRead = Uuio.read(s.d, ADR(chars[0]), NUMBER(chars)) DO
        IF charsRead < 0 THEN s.rc := Uerror.errno END;
        RETURN charsRead;
      END;
    END;
  END Fill;


PROCEDURE Seek(s: T; pos: CARDINAL): BOOLEAN RAISES {} =
  BEGIN
    LOCK UnixMutex.errno DO
      IF Unix.lseek(s.d, pos, Unix.L_SET) < 0 THEN
        s.rc := Uerror.errno;
        RETURN FALSE;
      ELSE
        RETURN TRUE;
      END;
    END;
  END Seek;


PROCEDURE Truncate(s: T; length: CARDINAL): BOOLEAN RAISES {} =
  BEGIN
    LOCK UnixMutex.errno DO
      IF Unix.ftruncate(s.d, length) < 0 THEN
        s.rc := Uerror.errno;
        RETURN FALSE;
      ELSE
        RETURN TRUE;
      END;
    END;
  END Truncate;


PROCEDURE Close(s: T): BOOLEAN RAISES {} =
  BEGIN
    LOCK UnixMutex.errno DO
      IF Unix.close(s.d) < 0 THEN
        s.rc := Uerror.errno;
        RETURN FALSE;
      ELSE
        RETURN TRUE;
      END;
    END;
  END Close;


PROCEDURE Error(s: T): Text.T RAISES {} =
  BEGIN
    RETURN OSError_ux.CodeToText(s.rc);
  END Error;


BEGIN
END Stream_ux.
