INTERFACE OSError_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT Ctypes;

IMPORT OSError;


REVEAL
  OSError.T = BRANDED REF Ctypes.int;
(* Unix error codes are just integers *)

PROCEDURE CodeToText(error: Ctypes.int): Text.T RAISES {};
(* Returns error message or "unknown error" if 'error' is not a valid error
code. *)

PROCEDURE Raise() RAISES {OSError.E};
(* Only to be called when
1) 'Unix.errnoMutex' is locked
2) a call to the Unix kernel or Unix library has just failed and set 'errno'
This procedure reads 'errno', sets up a 'OSError.T' value and then raises
'OSError.E' with that value as its argument *)

PROCEDURE Return(): OSError.T RAISES {};
(* Only to be called when
1) 'Unix.errnoMutex' is locked
2) a call to the Unix kernel or Unix library has just failed and set 'errno'
This procedure reads 'errno', sets up a 'OSError.T' value and returns it *)

END OSError_ux.
