INTERFACE UnixWait;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Ctypes;


(* Procedures which unpack the 'status' argument to a 'wait' call. This is a
halfway interface; it deals with 'status', a 'Ctypes.int' but returns Modula 3
types and is implemented in Modula 3 *)


(* The following discriminates between the two types of 'status' *) 

<* INLINE *> PROCEDURE WIFSTOPPED(status: Ctypes.int): BOOLEAN RAISES {};

TYPE
  Byte = [0..255];

(* The following return the field values if WIFSTOPPED(status) is zero *)

<* INLINE *> PROCEDURE Termsig(status: Ctypes.int): Byte RAISES {};
<* INLINE *> PROCEDURE Coredump(status: Ctypes.int): BOOLEAN RAISES {};
<* INLINE *> PROCEDURE Retcode(status: Ctypes.int): Byte RAISES {};


(* The following return the field values if WIFSTOPPED(status) is non zero *)

<* INLINE *> PROCEDURE Stopval(status: Ctypes.int): Byte RAISES {};
<* INLINE *> PROCEDURE Stopsig(status: Ctypes.int): Byte RAISES {};


(* If 'WIFSTOPPED' is zero the following can be used to see if the process
was signalled or if it exited *)

<* INLINE *> PROCEDURE WIFSIGNALED(status: Ctypes.int): BOOLEAN RAISES {};
<* INLINE *> PROCEDURE WIFEXITED(status: Ctypes.int): BOOLEAN RAISES {};


(* Sundry constants *)

CONST
  WSTOPPED  = 8_177;
  WNOHANG   = 1;
  WUNTRACED = 2; 

END UnixWait.
