MODULE UnixWait;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Word;
IMPORT Ctypes;


<* INLINE *> PROCEDURE Termsig(status: Ctypes.int): Byte RAISES {}=
  BEGIN
    RETURN Word.Extract(status, 0, 7);
  END Termsig;


<* INLINE *> PROCEDURE Coredump(status: Ctypes.int): BOOLEAN RAISES {}=
  BEGIN
    RETURN Word.Extract(status, 7, 1) # 0;
  END Coredump;


<* INLINE *> PROCEDURE Retcode(status: Ctypes.int): Byte RAISES {}=
  BEGIN
    RETURN Word.Extract(status, 8, 8);
  END Retcode;


<* INLINE *> PROCEDURE Stopval(status: Ctypes.int): Byte RAISES {}=
  BEGIN
    RETURN Word.Extract(status, 0, 8);
  END Stopval;


<* INLINE *> PROCEDURE Stopsig(status: Ctypes.int): Byte RAISES {}=
  BEGIN
    RETURN Word.Extract(status, 8, 8);
  END Stopsig;


<* INLINE *> PROCEDURE WIFSTOPPED(status: Ctypes.int): BOOLEAN RAISES {}=
  BEGIN
    RETURN Stopval(status) = WSTOPPED;
  END WIFSTOPPED;


<* INLINE *> PROCEDURE WIFSIGNALED(status: Ctypes.int): BOOLEAN RAISES {}=
  BEGIN
    RETURN Stopval(status) # WSTOPPED AND Termsig(status) # 0;
  END WIFSIGNALED;


<* INLINE *> PROCEDURE WIFEXITED(status: Ctypes.int): BOOLEAN RAISES {}=
  BEGIN
    RETURN Stopval(status) # WSTOPPED AND Termsig(status) = 0;
  END WIFEXITED;


BEGIN

END UnixWait.
