(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE Main;

IMPORT Stop;
IMPORT M3Context, M3Args, M3CUnit, M3ToolFrame;
IMPORT M3GTool, M3CFETool;
IMPORT M3AST_all;

PROCEDURE DoRun(c: M3Context.T; compileResult: INTEGER): INTEGER RAISES {}=
  VAR phases := M3CUnit.Status{M3CUnit.State.Parsed};
  BEGIN
    IF M3Args.GetFlag(M3GTool.Get(), M3GTool.SubstituteAP_Arg) THEN
      phases := M3CUnit.AllPhases;
    END; (* if *)
    compileResult := M3CFETool.CompileInContext(c, phases);
    IF NOT (compileResult < 0)  THEN
      compileResult := M3GTool.Run(c);
    END;
    RETURN compileResult;
  END DoRun;

BEGIN
  IF M3ToolFrame.Startup(DoRun, compile := FALSE) < 0 THEN
    Stop.Stop(Stop.Code.Bad);
  ELSE
    Stop.Stop(Stop.Code.Bad);
  END;
END Main.
