MODULE M3AST_AS;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT AST_Init;
IMPORT M3AST, M3AST_AS;
IMPORT M3AST_AS_F;

PROCEDURE IsA_USED_ID(n: M3AST.NODE;
    VAR(*out*) used_id: USED_ID): BOOLEAN RAISES {} =
  BEGIN
    RETURN n.IsA_USED_ID(used_id);
  END IsA_USED_ID;

PROCEDURE IsA_ID(n: M3AST.NODE;
    VAR(*out*) id: ID): BOOLEAN RAISES {} =
  BEGIN
    RETURN n.IsA_ID(id);
  END IsA_ID;

PROCEDURE IsA_END_SRC_NODE(n: M3AST.NODE;
    VAR(*out*) end_src_node: END_SRC_NODE): BOOLEAN RAISES {} =
  BEGIN
    TYPECASE n OF
    | Block(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Case_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | For_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | If_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Lock_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Loop_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Repeat_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Try_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Typecase_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | While_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | With_st(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Record_type(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    | Object_type(t) => end_src_node := t.vEND_SRC_NODE; RETURN TRUE
    ELSE
      RETURN FALSE
    END;
  END IsA_END_SRC_NODE;

(* Node creation *)

PROCEDURE NewModule_id(): Module_id RAISES {} =
  BEGIN
    WITH n = NEW(Module_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewModule_id;
            
PROCEDURE NewInterface_id(): Interface_id RAISES {} =
  BEGIN
    WITH n = NEW(Interface_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInterface_id;
         
PROCEDURE NewF_Interface_id(): F_Interface_id RAISES {} =
  BEGIN
    WITH n = NEW(F_Interface_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewF_Interface_id;
         
PROCEDURE NewInterface_AS_id(): Interface_AS_id RAISES {} =
  BEGIN
    WITH n = NEW(Interface_AS_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInterface_AS_id;
         
PROCEDURE NewF_Value_id(): F_Value_id RAISES {} =
  BEGIN
    WITH n = NEW(F_Value_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewF_Value_id;
         
PROCEDURE NewF_Var_id(): F_Var_id RAISES {} =
  BEGIN
    WITH n = NEW(F_Var_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewF_Var_id;
           
PROCEDURE NewF_Readonly_id(): F_Readonly_id RAISES {} =
  BEGIN
    WITH n = NEW(F_Readonly_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewF_Readonly_id;
      
PROCEDURE NewType_id(): Type_id RAISES {} =
  BEGIN
    WITH n = NEW(Type_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewType_id;
             
PROCEDURE NewConst_id(): Const_id RAISES {} =
  BEGIN
    WITH n = NEW(Const_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConst_id;
            
PROCEDURE NewVar_id(): Var_id RAISES {} =
  BEGIN
    WITH n = NEW(Var_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewVar_id;
               
PROCEDURE NewProc_id(): Proc_id RAISES {} =
  BEGIN
    WITH n = NEW(Proc_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewProc_id;
             
PROCEDURE NewEnum_id(): Enum_id RAISES {} =
  BEGIN
    WITH n = NEW(Enum_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewEnum_id;
             
PROCEDURE NewMethod_id(): Method_id RAISES {} =
  BEGIN
    WITH n = NEW(Method_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewMethod_id;
           
PROCEDURE NewOverride_id(): Override_id RAISES {} =
  BEGIN
    WITH n = NEW(Override_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewOverride_id;
           
PROCEDURE NewField_id(): Field_id RAISES {} =
  BEGIN
    WITH n = NEW(Field_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewField_id;
            
PROCEDURE NewFor_id(): For_id RAISES {} =
  BEGIN
    WITH n = NEW(For_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewFor_id;
              
PROCEDURE NewHandler_id(): Handler_id RAISES {} =
  BEGIN
    WITH n = NEW(Handler_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewHandler_id;
          
PROCEDURE NewTcase_id(): Tcase_id RAISES {} =
  BEGIN
    WITH n = NEW(Tcase_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTcase_id;
            
PROCEDURE NewWith_id(): With_id RAISES {} =
  BEGIN
    WITH n = NEW(With_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewWith_id;
             
PROCEDURE NewExc_id(): Exc_id RAISES {} =
  BEGIN
    WITH n = NEW(Exc_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExc_id;
              
PROCEDURE NewUsed_interface_id(): Used_interface_id RAISES {} =
  BEGIN
    WITH n = NEW(Used_interface_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUsed_interface_id;
    
PROCEDURE NewUsed_def_id(): Used_def_id RAISES {} =
  BEGIN
    WITH n = NEW(Used_def_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUsed_def_id;
          
PROCEDURE NewQual_used_id(): Qual_used_id RAISES {} =
  BEGIN
    WITH n = NEW(Qual_used_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewQual_used_id;
         
PROCEDURE NewCompilation_Unit(): Compilation_Unit RAISES {} =
  BEGIN
    WITH n = NEW(Compilation_Unit) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewCompilation_Unit;

PROCEDURE NewInterface(): Interface RAISES {} =
  BEGIN
    WITH n = NEW(Interface) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInterface;

PROCEDURE NewModule(): Module RAISES {} =
  BEGIN
    WITH n = NEW(Module) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewModule;

PROCEDURE NewInterface_gen_def(): Interface_gen_def RAISES {} =
  BEGIN
    WITH n = NEW(Interface_gen_def) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInterface_gen_def;

PROCEDURE NewModule_gen_def(): Module_gen_def RAISES {} =
  BEGIN
    WITH n = NEW(Module_gen_def) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewModule_gen_def;

PROCEDURE NewInterface_gen_ins(): Interface_gen_ins RAISES {} =
  BEGIN
    WITH n = NEW(Interface_gen_ins) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInterface_gen_ins;

PROCEDURE NewModule_gen_ins(): Module_gen_ins RAISES {} =
  BEGIN
    WITH n = NEW(Module_gen_ins) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewModule_gen_ins;

PROCEDURE NewUnsafe(): Unsafe RAISES {} =
  BEGIN
    WITH n = NEW(Unsafe) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUnsafe;

PROCEDURE NewImport_item(): Import_item RAISES {} =
  BEGIN
    WITH n = NEW(Import_item) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewImport_item;
       
PROCEDURE NewSimple_import(): Simple_import RAISES {} =
  BEGIN
    WITH n = NEW(Simple_import) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSimple_import;
       
PROCEDURE NewFrom_import(): From_import RAISES {} =
  BEGIN
    WITH n = NEW(From_import) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewFrom_import;
         
PROCEDURE NewRevelation_s(): Revelation_s RAISES {} =
  BEGIN
    WITH n = NEW(Revelation_s) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRevelation_s;
       
PROCEDURE NewConst_decl_s(): Const_decl_s RAISES {} =
  BEGIN
    WITH n = NEW(Const_decl_s) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConst_decl_s;
            
PROCEDURE NewType_decl_s(): Type_decl_s RAISES {} =
  BEGIN
    WITH n = NEW(Type_decl_s) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewType_decl_s;
             
PROCEDURE NewVar_decl_s(): Var_decl_s RAISES {} =
  BEGIN
    WITH n = NEW(Var_decl_s) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewVar_decl_s;
              
PROCEDURE NewExc_decl_s(): Exc_decl_s RAISES {} =
  BEGIN
    WITH n = NEW(Exc_decl_s) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExc_decl_s;
              
PROCEDURE NewProc_decl(): Proc_decl RAISES {} =
  BEGIN
    WITH n = NEW(Proc_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewProc_decl;
               
PROCEDURE NewConst_decl(): Const_decl RAISES {} =
  BEGIN
    WITH n = NEW(Const_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConst_decl;
          
PROCEDURE NewVar_decl(): Var_decl RAISES {} =
  BEGIN
    WITH n = NEW(Var_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewVar_decl;
            
PROCEDURE NewExc_decl(): Exc_decl RAISES {} =
  BEGIN
    WITH n = NEW(Exc_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExc_decl;
            
PROCEDURE NewSubtype_decl(): Subtype_decl RAISES {} =
  BEGIN
    WITH n = NEW(Subtype_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSubtype_decl;
       
PROCEDURE NewConcrete_decl(): Concrete_decl RAISES {} =
  BEGIN
    WITH n = NEW(Concrete_decl) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConcrete_decl;
      
PROCEDURE NewSubtype_reveal(): Subtype_reveal RAISES {} =
  BEGIN
    WITH n = NEW(Subtype_reveal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSubtype_reveal;
    
PROCEDURE NewConcrete_reveal(): Concrete_reveal RAISES {} =
  BEGIN
    WITH n = NEW(Concrete_reveal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConcrete_reveal;
   
PROCEDURE NewNamed_type(): Named_type RAISES {} =
  BEGIN
    WITH n = NEW(Named_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewNamed_type;
            
PROCEDURE NewInteger_type(): Integer_type RAISES {}=
  VAR v := NEW(Integer_type);
  BEGIN
    RETURN(v);    
  END NewInteger_type;

PROCEDURE NewReal_type(): Real_type RAISES {}=
  VAR v := NEW(Real_type);
  BEGIN
    RETURN(v);    
  END NewReal_type;

PROCEDURE NewLongReal_type(): LongReal_type RAISES {}=
  VAR v := NEW(LongReal_type);
  BEGIN
    RETURN(v);    
  END NewLongReal_type;

PROCEDURE NewExtended_type(): Extended_type RAISES {}=
  VAR v := NEW(Extended_type);
  BEGIN
    RETURN(v);    
  END NewExtended_type;

PROCEDURE NewNull_type(): Null_type RAISES {}=
  VAR v := NEW(Null_type);
  BEGIN
    RETURN(v);    
  END NewNull_type;

PROCEDURE NewRefAny_type(): RefAny_type RAISES {}=
  VAR v := NEW(RefAny_type);
  BEGIN
    RETURN(v);    
  END NewRefAny_type;

PROCEDURE NewAddress_type(): Address_type RAISES {}=
  VAR v := NEW(Address_type);
  BEGIN
    RETURN(v);    
  END NewAddress_type;

PROCEDURE NewRoot_type(): Root_type RAISES {}=
  VAR v := NEW(Root_type);
  BEGIN
    RETURN(v);    
  END NewRoot_type;

PROCEDURE NewEnumeration_type(): Enumeration_type RAISES {} =
  BEGIN
    WITH n = NEW(Enumeration_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewEnumeration_type;

PROCEDURE NewSubrange_type(): Subrange_type RAISES {} =
  BEGIN
    WITH n = NEW(Subrange_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSubrange_type;

PROCEDURE NewArray_type(): Array_type RAISES {} =
  BEGIN
    WITH n = NEW(Array_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewArray_type;

PROCEDURE NewRecord_type(): Record_type RAISES {} =
  BEGIN
    WITH n = NEW(Record_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRecord_type;

PROCEDURE NewObject_type(): Object_type RAISES {} =
  BEGIN
    WITH n = NEW(Object_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewObject_type;

PROCEDURE NewSet_type(): Set_type RAISES {} =
  BEGIN
    WITH n = NEW(Set_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSet_type;

PROCEDURE NewProcedure_type(): Procedure_type RAISES {} =
  BEGIN
    WITH n = NEW(Procedure_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewProcedure_type;

PROCEDURE NewRef_type(): Ref_type RAISES {} =
  BEGIN
    WITH n = NEW(Ref_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRef_type;

PROCEDURE NewPacked_type(): Packed_type RAISES {} =
  BEGIN
    WITH n = NEW(Packed_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewPacked_type;

PROCEDURE NewOpaque_type(): Opaque_type RAISES {} =
  BEGIN
    WITH n = NEW(Opaque_type) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewOpaque_type;

PROCEDURE NewBrand(): Brand RAISES {} =
  BEGIN
    WITH n = NEW(Brand) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBrand;

PROCEDURE NewUntraced(): Untraced RAISES {} =
  BEGIN
    WITH n = NEW(Untraced) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUntraced;

PROCEDURE NewFields(): Fields RAISES {} =
  BEGIN
    WITH n = NEW(Fields) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewFields;

PROCEDURE NewMethod(): Method RAISES {} =
  BEGIN
    WITH n = NEW(Method) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewMethod;

PROCEDURE NewOverride(): Override RAISES {} =
  BEGIN
    WITH n = NEW(Override) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewOverride;

PROCEDURE NewFormal_param(): Formal_param RAISES {} =
  BEGIN
    WITH n = NEW(Formal_param) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewFormal_param;

PROCEDURE NewRaisees_some(): Raisees_some RAISES {} =
  BEGIN
    WITH n = NEW(Raisees_some) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRaisees_some;

PROCEDURE NewRaisees_any(): Raisees_any RAISES {} =
  BEGIN
    WITH n = NEW(Raisees_any) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRaisees_any;

PROCEDURE NewRange(): Range RAISES {} =
  BEGIN
    WITH n = NEW(Range) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRange;

PROCEDURE NewRange_EXP(): Range_EXP RAISES {} =
  BEGIN
    WITH n = NEW(Range_EXP) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRange_EXP;

PROCEDURE NewInteger_literal(): Integer_literal RAISES {} =
  BEGIN
    WITH n = NEW(Integer_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewInteger_literal;

PROCEDURE NewReal_literal(): Real_literal RAISES {} =
  BEGIN
    WITH n = NEW(Real_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewReal_literal;

PROCEDURE NewLongReal_literal(): LongReal_literal RAISES {} =
  BEGIN
    WITH n = NEW(LongReal_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewLongReal_literal;

PROCEDURE NewExtended_literal(): Extended_literal RAISES {} =
  BEGIN
    WITH n = NEW(Extended_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExtended_literal;

PROCEDURE NewText_literal(): Text_literal RAISES {} =
  BEGIN
    WITH n = NEW(Text_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewText_literal;

PROCEDURE NewChar_literal(): Char_literal RAISES {} =
  BEGIN
    WITH n = NEW(Char_literal) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewChar_literal;

PROCEDURE NewNil_literal(): Nil_literal RAISES {}=
  VAR v := NEW(Nil_literal);
  BEGIN
    RETURN(v);    
  END NewNil_literal;

PROCEDURE NewExp_used_id(): Exp_used_id RAISES {} =
  BEGIN
    WITH n = NEW(Exp_used_id) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExp_used_id;
      
PROCEDURE NewConstructor(): Constructor RAISES {} =
  BEGIN
    WITH n = NEW(Constructor) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewConstructor;

PROCEDURE NewRANGE_EXP_elem(): RANGE_EXP_elem RAISES {} =
  BEGIN
    WITH n = NEW(RANGE_EXP_elem) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRANGE_EXP_elem;

PROCEDURE NewActual_elem(): Actual_elem RAISES {} =
  BEGIN
    WITH n = NEW(Actual_elem) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewActual_elem;

PROCEDURE NewPropagate(): Propagate RAISES {} =
  BEGIN
    WITH n = NEW(Propagate) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewPropagate;

PROCEDURE NewBinary(): Binary RAISES {} =
  BEGIN
    WITH n = NEW(Binary) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBinary;

PROCEDURE NewPlus(): Plus RAISES {} =
  BEGIN
    WITH n = NEW(Plus) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewPlus;

PROCEDURE NewMinus(): Minus RAISES {} =
  BEGIN
    WITH n = NEW(Minus) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewMinus;

PROCEDURE NewTimes(): Times RAISES {} =
  BEGIN
    WITH n = NEW(Times) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTimes;

PROCEDURE NewRdiv(): Rdiv RAISES {} =
  BEGIN
    WITH n = NEW(Rdiv) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRdiv;

PROCEDURE NewTextcat(): Textcat RAISES {} =
  BEGIN
    WITH n = NEW(Textcat) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTextcat;

PROCEDURE NewDiv(): Div RAISES {} =
  BEGIN
    WITH n = NEW(Div) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewDiv;

PROCEDURE NewMod(): Mod RAISES {} =
  BEGIN
    WITH n = NEW(Mod) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewMod;

PROCEDURE NewEq(): Eq RAISES {} =
  BEGIN
    WITH n = NEW(Eq) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewEq;

PROCEDURE NewNe(): Ne RAISES {} =
  BEGIN
    WITH n = NEW(Ne) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewNe;

PROCEDURE NewGt(): Gt RAISES {} =
  BEGIN
    WITH n = NEW(Gt) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewGt;

PROCEDURE NewLt(): Lt RAISES {} =
  BEGIN
    WITH n = NEW(Lt) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewLt;

PROCEDURE NewGe(): Ge RAISES {} =
  BEGIN
    WITH n = NEW(Ge) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewGe;

PROCEDURE NewLe(): Le RAISES {} =
  BEGIN
    WITH n = NEW(Le) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewLe;

PROCEDURE NewAnd(): And RAISES {} =
  BEGIN
    WITH n = NEW(And) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewAnd;

PROCEDURE NewOr(): Or RAISES {} =
  BEGIN
    WITH n = NEW(Or) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewOr;

PROCEDURE NewIn(): In RAISES {} =
  BEGIN
    WITH n = NEW(In) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewIn;

PROCEDURE NewSelect(): Select RAISES {} =
  BEGIN
    WITH n = NEW(Select) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewSelect;

PROCEDURE NewUnary(): Unary RAISES {} =
  BEGIN
    WITH n = NEW(Unary) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUnary;

PROCEDURE NewNot(): Not RAISES {} =
  BEGIN
    WITH n = NEW(Not) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewNot;

PROCEDURE NewUnaryplus(): Unaryplus RAISES {} =
  BEGIN
    WITH n = NEW(Unaryplus) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUnaryplus;

PROCEDURE NewUnaryminus(): Unaryminus RAISES {} =
  BEGIN
    WITH n = NEW(Unaryminus) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUnaryminus;

PROCEDURE NewDeref(): Deref RAISES {} =
  BEGIN
    WITH n = NEW(Deref) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewDeref;

PROCEDURE NewCall(): Call RAISES {} =
  BEGIN
    WITH n = NEW(Call) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewCall;

PROCEDURE NewNEWCall(): NEWCall RAISES {} =
  BEGIN
    WITH n = NEW(NEWCall) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewNEWCall;

PROCEDURE NewIndex(): Index RAISES {} =
  BEGIN
    WITH n = NEW(Index) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewIndex;

PROCEDURE NewActual(): Actual RAISES {} =
  BEGIN
    WITH n = NEW(Actual) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewActual;

PROCEDURE NewAssign_st(): Assign_st RAISES {} =
  BEGIN
    WITH n = NEW(Assign_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewAssign_st;

PROCEDURE NewCall_st(): Call_st RAISES {} =
  BEGIN
    WITH n = NEW(Call_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewCall_st;

PROCEDURE NewCase_st(): Case_st RAISES {} =
  BEGIN
    WITH n = NEW(Case_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewCase_st;

PROCEDURE NewEval_st(): Eval_st RAISES {} =
  BEGIN
    WITH n = NEW(Eval_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewEval_st;

PROCEDURE NewExit_st(): Exit_st RAISES {} =
  BEGIN
    WITH n = NEW(Exit_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewExit_st;

PROCEDURE NewFor_st(): For_st RAISES {} =
  BEGIN
    WITH n = NEW(For_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewFor_st;

PROCEDURE NewIf_st(): If_st RAISES {} =
  BEGIN
    WITH n = NEW(If_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewIf_st;

PROCEDURE NewLock_st(): Lock_st RAISES {} =
  BEGIN
    WITH n = NEW(Lock_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewLock_st;

PROCEDURE NewLoop_st(): Loop_st RAISES {} =
  BEGIN
    WITH n = NEW(Loop_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewLoop_st;

PROCEDURE NewRaise_st(): Raise_st RAISES {} =
  BEGIN
    WITH n = NEW(Raise_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRaise_st;

PROCEDURE NewRepeat_st(): Repeat_st RAISES {} =
  BEGIN
    WITH n = NEW(Repeat_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewRepeat_st;

PROCEDURE NewReturn_st(): Return_st RAISES {} =
  BEGIN
    WITH n = NEW(Return_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewReturn_st;

PROCEDURE NewTry_st(): Try_st RAISES {} =
  BEGIN
    WITH n = NEW(Try_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTry_st;

PROCEDURE NewTypecase_st(): Typecase_st RAISES {} =
  BEGIN
    WITH n = NEW(Typecase_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTypecase_st;

PROCEDURE NewWhile_st(): While_st RAISES {} =
  BEGIN
    WITH n = NEW(While_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewWhile_st;

PROCEDURE NewWith_st(): With_st RAISES {} =
  BEGIN
    WITH n = NEW(With_st) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewWith_st;

PROCEDURE NewBlock(): Block RAISES {} =
  BEGIN
    WITH n = NEW(Block) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBlock;

PROCEDURE NewCase(): Case RAISES {} =
  BEGIN
    WITH n = NEW(Case) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewCase;

PROCEDURE NewElse_stm(): Else_stm RAISES {} =
  BEGIN
    WITH n = NEW(Else_stm) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewElse_stm;

PROCEDURE NewBy(): By RAISES {} =
  BEGIN
    WITH n = NEW(By) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBy;

PROCEDURE NewElsif(): Elsif RAISES {} =
  BEGIN
    WITH n = NEW(Elsif) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewElsif;

PROCEDURE NewTry_except(): Try_except RAISES {} =
  BEGIN
    WITH n = NEW(Try_except) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTry_except;

PROCEDURE NewTry_finally(): Try_finally RAISES {} =
  BEGIN
    WITH n = NEW(Try_finally) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTry_finally;

PROCEDURE NewTcase(): Tcase RAISES {} =
  BEGIN
    WITH n = NEW(Tcase) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewTcase;

PROCEDURE NewHandler(): Handler RAISES {} =
  BEGIN
    WITH n = NEW(Handler) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewHandler;

PROCEDURE NewBinding(): Binding RAISES {} =
  BEGIN
    WITH n = NEW(Binding) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBinding;

PROCEDURE NewBad_EXP(): Bad_EXP RAISES {} =
  BEGIN
    WITH n = NEW(Bad_EXP) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBad_EXP;

PROCEDURE NewBad_M3TYPE(): Bad_M3TYPE RAISES {} =
  BEGIN
    WITH n = NEW(Bad_M3TYPE) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBad_M3TYPE;

PROCEDURE NewBad_STM(): Bad_STM RAISES {} =
  BEGIN
    WITH n = NEW(Bad_STM) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewBad_STM;

PROCEDURE NewUSED_ID(): USED_ID RAISES {} =
  BEGIN
    WITH n = NEW(USED_ID) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewUSED_ID;

PROCEDURE NewEND_SRC_NODE(): END_SRC_NODE RAISES {} =
  BEGIN
    WITH n = NEW(END_SRC_NODE) DO
      EVAL n.init();
      RETURN n;
    END;
  END NewEND_SRC_NODE;


BEGIN

END M3AST_AS.
