INTERFACE M3AST_PG;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Standard pragmas, as defined in the report, i.e. "INLINE" and "EXTERNAL".
   There was a time when these were part of the language syntax, so they are 
   integrated more closely with the AST than other pragmas. In particular, 
   rather than being specified in this interface as extensions to the relevant
   AST nodes, they are actually specified in "M3AST_AS", e.g. the "pg_inline"
   attribute on a "Proc_decl" node. This interface simply defines the
   new nodes that form the type of the "pg_" attributes, and gives their
   attributes, in the usual abstract fashion. See a companion interface,
   e.g. "M3AST_PG_F", for the actual representation. *)

IMPORT M3AST, M3AST_AS;

TYPE

(* <*INLINE*> PROCEDURE ... *)

  Inline <: M3AST_AS.SRC_NODE;
  Inline_NULL = Inline;

(* <*EXTERNAL L*> (DECL | INTERFACE) *)

(* We use the general approach to multiple inheritance here and
   introduce the class "EXTERNAL_DECL" to carry the information
   as to whether an "Interface" or "DECL" node is "EXTERNAL". 
   So, in "M3AST_AS", there is an attribute "vEXTERNAL_DECL"
   on "Interface" and "DECL" nodes. *)

  EXTERNAL_DECL <: M3AST.NODE;
  (* pg_external: External_NULL *)

  External <: M3AST_AS.SRC_NODE;
  (* lx_lang_spec: M3AST_LX.Text_rep *)

  External_NULL = External;
  External_NULL_UNSET = External_NULL;

(* Since the semantic analyser chooses to use "DEF_ID" nodes to
   carry most of the semantic information, it is convenient to
   propagate the "external" information to some "DEF_ID" nodes.
   Again we use multiple inheritance, and in "M3AST_SM"
   the associated nodes will contain a "vEXTERNAL_ID" attribute.
   The value of the "pg_external" field is a back pointer to
   the "External" node of the enclosing "EXTERNAL" declaration.
   The value of "pg_external" will be NIL if the "EXTERNAL_ID"
   is not "EXTERNAL". Note that for all "EXTERNAL_ID" nodes
   in an interface that is "EXTERNAL", the value of "pg_external"
   will be non-NIL. *)

  EXTERNAL_ID <: M3AST.NODE;    (* Ids that can be EXTERNAL *)
  (* pg_external: M3AST_PG.External_NULL_UNSET *)

PROCEDURE IsA_EXTERNAL_DECL(n: M3AST.NODE;
    VAR(*out*) external_decl: EXTERNAL_DECL): BOOLEAN RAISES {};
(* ISTYPE(n, Interface) OR ISTYPE(n, DECL) *)

PROCEDURE IsA_EXTERNAL_ID(n: M3AST.NODE;
    VAR(*out*) external_id: EXTERNAL_ID): BOOLEAN RAISES {};
(* Interface_id OR Proc_id OR Var_id OR Const_id OR Type_id OR Exc_id *)


(*--------------------------------------------------------------------------
                   Node creation procedures

  These take the form:

  PROCEDURE NewNode(): Node RAISES {};

--------------------------------------------------------------------------*)

PROCEDURE NewInline(): Inline RAISES {};
PROCEDURE NewExternal(): External RAISES {};

PROCEDURE NewEXTERNAL_DECL(): EXTERNAL_DECL RAISES {};
PROCEDURE NewEXTERNAL_ID(): EXTERNAL_ID RAISES {};

(* This proc returns distinguished values that indicates UNSET. *)

PROCEDURE UNSET_External(): External_NULL_UNSET RAISES {};

END M3AST_PG.
