MODULE M3AST_AS_Display EXPORTS M3AST_AS_Display, M3AST_PG_Display;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT M3AST_AS, M3AST_PG;
IMPORT M3AST_AS_F, M3AST_PG_F;
IMPORT
    SeqM3AST_AS_IMPORTED, SeqM3AST_AS_USED_ID,
    SeqM3AST_AS_Used_interface_id, SeqM3AST_AS_Used_def_id,
    SeqM3AST_AS_Import_item, SeqM3AST_AS_Override,
    SeqM3AST_AS_REVELATION, SeqM3AST_AS_DECL_REVL,
    SeqM3AST_AS_Const_decl, SeqM3AST_AS_TYPE_DECL,
    SeqM3AST_AS_Var_decl, SeqM3AST_AS_Exc_decl,
    SeqM3AST_AS_Var_id, SeqM3AST_AS_Exc_id,
    SeqM3AST_AS_Enum_id, SeqM3AST_AS_Field_id,
    SeqM3AST_AS_FORMAL_ID, SeqM3AST_AS_Qual_used_id,
    SeqM3AST_AS_Fields, SeqM3AST_AS_Method,
    SeqM3AST_AS_M3TYPE, SeqM3AST_AS_TYPE_SPEC,
    SeqM3AST_AS_Formal_param, SeqM3AST_AS_CONS_ELEM,
    SeqM3AST_AS_EXP, SeqM3AST_AS_Actual,
    SeqM3AST_AS_Case, SeqM3AST_AS_STM,
    SeqM3AST_AS_Elsif, SeqM3AST_AS_Tcase,
    SeqM3AST_AS_Handler, SeqM3AST_AS_Binding,
    SeqM3AST_AS_RANGE_EXP, SeqM3AST_AS_F_Interface_id;

IMPORT AST_DisplayRep;
IMPORT M3ASTDisplay_handle;

IMPORT IO;
IMPORT M3CId, M3CLiteral;
IMPORT M3PPSmarts;
FROM M3PPIO IMPORT
  D, SD, DS, SDS, SCNL, CS, SCS, Indent, NLIncIndent, NLDecIndent, SSP,
  IncIndent, DecIndent, NL, NL2, SSP_D, SSP_DS, SSP_SD, SSP_SDS, Indent_SSP;

(*PRIVATE*)
PROCEDURE VisitSeqStm(seqStm: SeqM3AST_AS_STM.T; h: AST_DisplayRep.Handle)
     (*RAISES {M3ASTWalk.Aborted,ANY}*) =
  VAR
    m: M3AST_AS.STM;
    iter := SeqM3AST_AS_STM.NewIter(seqStm);
  BEGIN
    WHILE SeqM3AST_AS_STM.Next(iter, m) DO 
      h.Visit(m);
      SCNL(h);
    END;
  END VisitSeqStm;

(*PRIVATE*)
PROCEDURE Tag(st: M3AST_AS.STM; h: AST_DisplayRep.Handle) RAISES {}=
  BEGIN
    
  END Tag;

(*PRIVATE*)
PROCEDURE VisitEXTERNAL_DECL(n: M3AST_PG.External_NULL;
    h: AST_DisplayRep.Handle) RAISES ANY=
  BEGIN
    IF n # NIL THEN h.Visit(n) END;
  END VisitEXTERNAL_DECL;

(*PRIVATE*)
PROCEDURE VisitUNIT_WITH_BODY(n: M3AST_AS_F.UNIT_WITH_BODY; 
    h: AST_DisplayRep.Handle) RAISES ANY=
  VAR
    m2: M3AST_AS.IMPORTED;
    iter2 := SeqM3AST_AS_IMPORTED.NewIter(n.as_import_s);
  BEGIN
    IF NOT SeqM3AST_AS_IMPORTED.Empty(n.as_import_s) THEN NL(h); END;
    WHILE SeqM3AST_AS_IMPORTED.Next(iter2, m2) DO h.Visit(m2); END;
    NL2(h);
    h.Visit(n.as_block);
  END VisitUNIT_WITH_BODY;

(*PRIVATE*)
PROCEDURE VisitUNIT_GEN_DEF(n: M3AST_AS_F.UNIT_GEN_DEF; h: AST_DisplayRep.Handle)
     RAISES ANY=
  VAR iter := SeqM3AST_AS_F_Interface_id.NewIter(n.as_id_s);
    m: M3AST_AS.F_Interface_id;
    isFirst := TRUE;
  BEGIN
    D("(", h);
    WHILE SeqM3AST_AS_F_Interface_id.Next(iter, m) DO
      Between(isFirst, CS, h); h.Visit(m);
    END;
    D(")", h);
  END VisitUNIT_GEN_DEF;

(*PRIVATE*)
PROCEDURE VisitUNIT_GEN_INS(n: M3AST_AS_F.UNIT_GEN_INS;
    h: AST_DisplayRep.Handle)
     RAISES ANY=
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    h.Visit(n.as_gen_id);
    D("(", h);
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO
      Between(isFirst, CS, h); h.Visit(m);
    END;
    D(")", h);
  END VisitUNIT_GEN_INS;

(*PRIVATE*)
PROCEDURE Between(
    VAR isFirst: BOOLEAN;
    p: PROCEDURE(h: AST_DisplayRep.Handle) RAISES {IO.Error};
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error} =
  BEGIN
    IF isFirst THEN isFirst := FALSE; RETURN; END;
    p(h);
  END Between;

(*PRIVATE*)
PROCEDURE DECL_Prelude(n: M3AST_AS.SRC_NODE; s: TEXT;
    h: AST_DisplayRep.Handle) RAISES {}=
  VAR
    e_decl: M3AST_PG.EXTERNAL_DECL;
  BEGIN
    Indent(h);
    IF M3AST_PG.IsA_EXTERNAL_DECL(n, e_decl) THEN
      VisitEXTERNAL_DECL(e_decl.pg_external, h);
    END; (* if *)
    SSP_D(n, s, h);
    NLIncIndent(h);
  END DECL_Prelude;

(*PRIVATE*)
PROCEDURE UnitPostlude(n: M3AST_AS_F.UNIT; h: AST_DisplayRep.Handle) RAISES {}=
  BEGIN
    D(M3CId.ToText(n.as_id.lx_symrep), h); D(".", h); NL(h);
  END UnitPostlude;


(* The method for displaying id's *)
PROCEDURE ID(n: M3AST_AS_F.ID; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_D(n, M3CId.ToText(n.lx_symrep), h);
  END ID;

PROCEDURE Qual_used_id(n: M3AST_AS_F.Qual_used_id; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_intf_id # NIL THEN h.Visit(n.as_intf_id); D(".", h) END;
    h.Visit(n.as_id);
  END Qual_used_id;


PROCEDURE Compilation_Unit(n: M3AST_AS_F.Compilation_Unit; 
      h: AST_DisplayRep.Handle) RAISES ANY =
  BEGIN
    h.Visit(n.as_root);
  END Compilation_Unit;


PROCEDURE Interface(n: M3AST_AS_F.Interface; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.isModule := FALSE;
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h); 
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    SSP_DS(n, "INTERFACE", h);
    h.Visit(n.as_id);
    SCNL(h);
    VisitUNIT_WITH_BODY(n, h);
    UnitPostlude(n, h);
  END Interface;


PROCEDURE Module(n: M3AST_AS_F.Module; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Used_interface_id;
    iter := SeqM3AST_AS_Used_interface_id.NewIter(n.as_export_s);
    isFirst := TRUE;
  BEGIN
    h.isModule := TRUE;
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    SSP_DS(n, "MODULE", h);
    h.Visit(n.as_id);
    IF NOT SeqM3AST_AS_Used_interface_id.Empty(n.as_export_s) THEN SDS("EXPORTS", h); END;
    WHILE SeqM3AST_AS_Used_interface_id.Next(iter, m) DO
      Between(isFirst, CS, h); h.Visit(m);
    END;
    SCNL(h);
    VisitUNIT_WITH_BODY(n, h);
    UnitPostlude(n, h);
  END Module;

PROCEDURE Interface_gen_def(n: M3AST_AS_F.Interface_gen_def; 
    h: AST_DisplayRep.Handle) RAISES ANY =
  BEGIN
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h); 
    SSP_DS(n, "GENERIC INTERFACE", h);
    h.Visit(n.as_id);
    VisitUNIT_GEN_DEF(n, h);
    VisitUNIT_WITH_BODY(n, h);
    UnitPostlude(n, h);
  END Interface_gen_def;


PROCEDURE Module_gen_def(n: M3AST_AS_F.Module_gen_def; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.isModule := TRUE;
    SSP_DS(n, "MODULE", h);
    h.Visit(n.as_id);
    VisitUNIT_GEN_DEF(n, h);
    SCNL(h);
    VisitUNIT_WITH_BODY(n, h);
    UnitPostlude(n, h);
  END Module_gen_def;


PROCEDURE Interface_gen_ins(n: M3AST_AS_F.Interface_gen_ins; 
    h: AST_DisplayRep.Handle) RAISES ANY =
  BEGIN
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    SSP_DS(n, "INTERFACE", h);
    h.Visit(n.as_id);
    SDS("=", h);
    VisitUNIT_GEN_INS(n, h);
    NL(h); DS("END", h);
    UnitPostlude(n, h);
  END Interface_gen_ins;


PROCEDURE Module_gen_ins(n: M3AST_AS_F.Module_gen_ins; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_unsafe # NIL THEN h.Visit(n.as_unsafe); END;
    SSP_DS(n, "MODULE", h);
    h.Visit(n.as_id);
    SDS("=", h);
    VisitUNIT_GEN_INS(n, h);
    NL(h); DS("END", h);
    UnitPostlude(n, h);
  END Module_gen_ins;


PROCEDURE Unsafe(n: M3AST_AS_F.Unsafe; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_DS(n, "UNSAFE", h);
  END Unsafe;

PROCEDURE Import_item(
    n: M3AST_AS_F.Import_item; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP(n, h);
    h.Visit(n.as_intf_id);
    IF n.as_id # NIL THEN
      SDS("AS", h);
      h.Visit(n.as_id);
    END;
  END Import_item;

PROCEDURE Simple_import(n: M3AST_AS_F.Simple_import; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Import_item;
    iter := SeqM3AST_AS_Import_item.NewIter(n.as_import_item_s);
    isFirst := TRUE;
  BEGIN
    SSP_DS(n, "IMPORT", h);
    WHILE SeqM3AST_AS_Import_item.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    SCNL(h);
  END Simple_import;


PROCEDURE From_import(n: M3AST_AS_F.From_import; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Used_def_id;
    iter := SeqM3AST_AS_Used_def_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    SSP_DS(n, "FROM", h);
    h.Visit(n.as_intf_id);
    SDS("IMPORT", h);
    WHILE SeqM3AST_AS_Used_def_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    SCNL(h);
  END From_import;


PROCEDURE Revelation_s(n: M3AST_AS_F.Revelation_s; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.REVELATION;
    iter := SeqM3AST_AS_REVELATION.NewIter(n.as_reveal_s);
  BEGIN
    DECL_Prelude(n, "REVEAL", h);
    WHILE SeqM3AST_AS_REVELATION.Next(iter, m) DO h.Visit(m); END;
    DecIndent(h);
  END Revelation_s;


PROCEDURE Const_decl_s(n: M3AST_AS_F.Const_decl_s; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Const_decl;
    iter := SeqM3AST_AS_Const_decl.NewIter(n.as_const_decl_s);
  BEGIN
    DECL_Prelude(n, "CONST", h);
    WHILE SeqM3AST_AS_Const_decl.Next(iter, m) DO h.Visit(m); END;
    DecIndent(h);
  END Const_decl_s;


PROCEDURE Type_decl_s(n: M3AST_AS_F.Type_decl_s; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.TYPE_DECL;
    iter := SeqM3AST_AS_TYPE_DECL.NewIter(n.as_type_decl_s);
  BEGIN
    DECL_Prelude(n, "TYPE", h);
    WHILE SeqM3AST_AS_TYPE_DECL.Next(iter, m) DO h.Visit(m); END;
    DecIndent(h);
  END Type_decl_s;


PROCEDURE Var_decl_s(n: M3AST_AS_F.Var_decl_s; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Var_decl;
    iter := SeqM3AST_AS_Var_decl.NewIter(n.as_var_decl_s);
  BEGIN
    DECL_Prelude(n, "VAR", h);
    WHILE SeqM3AST_AS_Var_decl.Next(iter, m) DO h.Visit(m); END;
    DecIndent(h);
  END Var_decl_s;


PROCEDURE Exc_decl_s(n: M3AST_AS_F.Exc_decl_s; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Exc_decl;
    iter := SeqM3AST_AS_Exc_decl.NewIter(n.as_exc_decl_s);
  BEGIN
    DECL_Prelude(n, "EXCEPTION", h);
    WHILE SeqM3AST_AS_Exc_decl.Next(iter, m) DO h.Visit(m); END;
    DecIndent(h);
  END Exc_decl_s;


PROCEDURE Proc_decl(n: M3AST_AS_F.Proc_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    NL(h); Indent(h);
    VisitEXTERNAL_DECL(n.vEXTERNAL_DECL.pg_external, h);
    IF n.pg_inline # NIL THEN h.Visit(n.pg_inline); END;
    SSP_DS(n, "PROCEDURE", h);
    h.Visit(n.as_id);
    h.suppressPROC := TRUE; h.Visit(n.as_type);
    IF n.as_body # NIL THEN 
      D("=", h); 
      NLIncIndent(h);
      h.Visit(n.as_body); 
      D(M3CId.ToText(n.as_id.lx_symrep), h);
      DecIndent(h);
    END;
    SCNL(h); NL(h);
  END Proc_decl;

PROCEDURE Inline(n: M3AST_PG_F.Inline; h: AST_DisplayRep.Handle) 
     (*RAISES ANY*)=
  BEGIN
    DS("<*INLINE*>", h);
  END Inline;

PROCEDURE Const_decl(n: M3AST_AS_F.Const_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_id);
    IF n.as_type # NIL THEN DS(":", h); h.Visit(n.as_type); END;
    SDS("=", h);
    h.Visit(n.as_exp);
    SCNL(h);
  END Const_decl;


PROCEDURE Var_decl(n: M3AST_AS_F.Var_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Var_id;
    iter := SeqM3AST_AS_Var_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Indent_SSP(n, h);
    WHILE SeqM3AST_AS_Var_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_type # NIL THEN DS(":", h); h.Visit(n.as_type); END;
    IF n.as_default # NIL THEN DS(":=", h); h.Visit(n.as_default); END;
    SCNL(h);
  END Var_decl;


PROCEDURE Exc_decl(n: M3AST_AS_F.Exc_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_id);
    IF n.as_type # NIL THEN D("(", h); h.Visit(n.as_type); D(")", h); END;
    SCNL(h);
  END Exc_decl;


PROCEDURE Subtype_decl(n: M3AST_AS_F.Subtype_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    TYPE_DECL(n, h);
  END Subtype_decl;

(* PRIVATE *)
PROCEDURE TYPE_DECL(n: M3AST_AS_F.TYPE_DECL; h: AST_DisplayRep.Handle)=
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_id); 
    IF ISTYPE(n, M3AST_AS.Subtype_decl) THEN SDS("<:", h)
    ELSE SDS("=", h);
    END;
    h.Visit(n.as_type);
    SCNL(h);
  END TYPE_DECL;


PROCEDURE Concrete_decl(n: M3AST_AS_F.Concrete_decl; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    TYPE_DECL(n, h);
  END Concrete_decl;


PROCEDURE Subtype_reveal(
    n: M3AST_AS_F.Subtype_reveal;
    h: AST_DisplayRep.Handle) RAISES ANY =
  BEGIN
    REVELATION(n, h);
  END Subtype_reveal;


(* PRIVATE *)
PROCEDURE REVELATION(n: M3AST_AS_F.REVELATION; h: AST_DisplayRep.Handle)=
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_qual_id); 
    IF ISTYPE(n, M3AST_AS.Subtype_reveal) THEN SDS("<:", h)
    ELSE SDS("=", h);
    END;
    h.Visit(n.as_type);
    SCNL(h);
  END REVELATION;

PROCEDURE Concrete_reveal(n: M3AST_AS_F.Concrete_reveal;
    h: AST_DisplayRep.Handle) RAISES ANY =
  BEGIN
    REVELATION(n, h);
  END Concrete_reveal;


PROCEDURE Named_type(n: M3AST_AS_F.Named_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_qual_id);
  END Named_type;


PROCEDURE Integer_type(
    n: M3AST_AS_F.Integer_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "INTEGER", h);
  END Integer_type;

PROCEDURE Real_type(
    n: M3AST_AS_F.Real_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "REAL", h);
  END Real_type;

PROCEDURE LongReal_type(
    n: M3AST_AS_F.LongReal_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "LONGREAL", h);
  END LongReal_type;

PROCEDURE Extended_type(
    n: M3AST_AS_F.Extended_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "EXTENDED", h);
  END Extended_type;

PROCEDURE Null_type(
    n: M3AST_AS_F.Null_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "NULL", h);
  END Null_type;

PROCEDURE RefAny_type(
    n: M3AST_AS_F.RefAny_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "REFANY", h);
  END RefAny_type;

PROCEDURE Address_type(
    n: M3AST_AS_F.Address_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "ADDRESS", h);
  END Address_type;

PROCEDURE Root_type(
    n: M3AST_AS_F.Root_type; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    IF n.as_trace_mode # NIL THEN SSP_D(n, "UNTRACED ROOT", h);
    ELSE SSP_D(n, "ROOT", h);
    END;
  END Root_type;

PROCEDURE Enumeration_type(n: M3AST_AS_F.Enumeration_type;
    h: AST_DisplayRep.Handle) RAISES ANY =
  VAR
    m: M3AST_AS.Enum_id;
    iter := SeqM3AST_AS_Enum_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    SSP_D(n, "{", h);
    WHILE SeqM3AST_AS_Enum_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    D("}", h);
  END Enumeration_type;


PROCEDURE Subrange_type(n: M3AST_AS_F.Subrange_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_D(n, "[", h);
    h.Visit(n.as_range);
    D("]", h);
  END Subrange_type;


PROCEDURE Array_type(n: M3AST_AS_F.Array_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_indextype_s);
    isFirst := TRUE;
  BEGIN
    SSP_DS(n, "ARRAY", h);
    WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    SDS("OF", h);
    h.Visit(n.as_elementtype);
  END Array_type;


PROCEDURE Record_type(n: M3AST_AS_F.Record_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
  BEGIN
    SSP_D(n, "RECORD", h);
    NLIncIndent(h);
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO 
      h.Visit(m); 
    END;
    DecIndent(h); Indent(h); D("END", h);
  END Record_type;


PROCEDURE Object_type(n: M3AST_AS_F.Object_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Fields;
    iter := SeqM3AST_AS_Fields.NewIter(n.as_fields_s);
    m2: M3AST_AS.Method;
    iter2 := SeqM3AST_AS_Method.NewIter(n.as_method_s);
    m3: M3AST_AS.Override;
    iter3 := SeqM3AST_AS_Override.NewIter(n.as_override_s);
  BEGIN
    SSP(n, h);
    IF n.as_ancestor # NIL THEN h.Visit(n.as_ancestor); D(" ", h); END;
    IF n.as_brand # NIL THEN h.Visit(n.as_brand); END;
    D("OBJECT", h); NLIncIndent(h);
    WHILE SeqM3AST_AS_Fields.Next(iter, m) DO h.Visit(m); END;
    IF NOT SeqM3AST_AS_Method.Empty(n.as_method_s) THEN
      DecIndent(h); Indent(h); D("METHODS", h); NLIncIndent(h);
      WHILE SeqM3AST_AS_Method.Next(iter2, m2) DO h.Visit(m2); END;
    END; (* if *)
    IF NOT SeqM3AST_AS_Override.Empty(n.as_override_s) THEN
      DecIndent(h); Indent(h); D("OVERRIDES", h); NLIncIndent(h);
      WHILE SeqM3AST_AS_Override.Next(iter3, m3) DO h.Visit(m3); END;
    END; (* if *)
    DecIndent(h); Indent(h); D("END", h); 
  END Object_type;


PROCEDURE Set_type(n: M3AST_AS_F.Set_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_DS(n, "SET OF", h);
    h.Visit(n.as_type);
  END Set_type;


PROCEDURE Procedure_type(n: M3AST_AS_F.Procedure_type; 
    h: AST_DisplayRep.Handle) RAISES ANY =
  VAR
    m: M3AST_AS.Formal_param;
    iter := SeqM3AST_AS_Formal_param.NewIter(n.as_formal_param_s);
    isFirst := TRUE;
  BEGIN
    IF NOT h.suppressPROC THEN SSP_SD(n, "PROCEDURE", h); D("(", h);
    ELSE SSP_D(n, "(", h);
    END;
    h.suppressPROC := FALSE;
    WHILE SeqM3AST_AS_Formal_param.Next(iter, m) DO
      Between(isFirst, SCS, h); h.Visit(m); 
    END;
    D(")", h);
    IF n.as_result_type # NIL THEN DS(":", h); h.Visit(n.as_result_type); END;
    IF n.as_raises # NIL THEN h.Visit(n.as_raises); END;
  END Procedure_type;


PROCEDURE Ref_type(n: M3AST_AS_F.Ref_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    IF n.as_trace_mode # NIL THEN h.Visit(n.as_trace_mode); END;
    IF n.as_brand # NIL THEN h.Visit(n.as_brand); END;
    SSP_DS(n, "REF", h);
    h.Visit(n.as_type);
  END Ref_type;


PROCEDURE Packed_type(n: M3AST_AS_F.Packed_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_DS(n, "BITS", h);
    h.Visit(n.as_exp);
    SDS("FOR", h);
    h.Visit(n.as_type);
  END Packed_type;


PROCEDURE Opaque_type(n: M3AST_AS_F.Opaque_type; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_type);
  END Opaque_type;


PROCEDURE Brand(
    n: M3AST_AS_F.Brand; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_DS(n, "BRANDED", h);
    IF n.as_exp # NIL THEN h.Visit(n.as_exp) END;
  END Brand;


PROCEDURE Untraced(
    n: M3AST_AS_F.Untraced; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_DS(n, "UNTRACED", h);
  END Untraced;


PROCEDURE Fields(n: M3AST_AS_F.Fields; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Field_id;
    iter := SeqM3AST_AS_Field_id.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    Indent_SSP(n, h);
    WHILE SeqM3AST_AS_Field_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_type # NIL THEN DS(":", h); h.Visit(n.as_type); END;
    IF n.as_default # NIL THEN SDS(":=", h); h.Visit(n.as_default); END;
    SCNL(h);
  END Fields;


PROCEDURE Method(n: M3AST_AS_F.Method; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_id);
    h.suppressPROC := TRUE; h.Visit(n.as_type);
    IF n.as_default # NIL THEN SDS(":=", h); h.Visit(n.as_default); END;
    SCNL(h);
  END Method;


PROCEDURE Override(n: M3AST_AS_F.Override; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_id);
    SDS(":=", h); h.Visit(n.as_default);
    SCNL(h);
  END Override;


PROCEDURE Formal_param(n: M3AST_AS_F.Formal_param; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.FORMAL_ID;
    iter := SeqM3AST_AS_FORMAL_ID.NewIter(n.as_id_s);
    isFirst := TRUE;
  BEGIN
    M3PPSmarts.SeeIfNodeFits(n, h);
    SSP(n, h);
    WHILE SeqM3AST_AS_FORMAL_ID.Next(iter, m) DO 
      IF isFirst THEN
        TYPECASE m OF
        | M3AST_AS.F_Var_id => DS("VAR", h);
        | M3AST_AS.F_Readonly_id => DS("READONLY", h);
        ELSE (* VALUE implied *)
        END;
      END; (* if *)
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_formal_type # NIL THEN DS(":", h); h.Visit(n.as_formal_type); END;
    IF n.as_default # NIL THEN SDS(":=", h); h.Visit(n.as_default); END;
  END Formal_param;


PROCEDURE Raisees_any(n: M3AST_AS_F.Raisees_any; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_SD(n, "RAISES ANY", h);
  END Raisees_any;


PROCEDURE Raisees_some(n: M3AST_AS_F.Raisees_some; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_raisees_s);
    isFirst := TRUE;
  BEGIN
    SSP_SD(n, "RAISES ", h);
    D("{", h);
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    D("}", h);
  END Raisees_some;


PROCEDURE Range(n: M3AST_AS_F.Range; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp1);
    SDS("..", h);
    h.Visit(n.as_exp2);
  END Range;


PROCEDURE Range_EXP(n: M3AST_AS_F.Range_EXP; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_exp);
  END Range_EXP;


PROCEDURE NUMERIC_LITERAL(
    n: M3AST_AS_F.NUMERIC_LITERAL; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, M3CLiteral.ToText(n.lx_numrep), h);
  END NUMERIC_LITERAL;

PROCEDURE Integer_literal(
    n: M3AST_AS_F.Integer_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    NUMERIC_LITERAL(n, h);
  END Integer_literal;


PROCEDURE Real_literal(
    n: M3AST_AS_F.Real_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    NUMERIC_LITERAL(n, h);
  END Real_literal;


PROCEDURE LongReal_literal(
    n: M3AST_AS_F.LongReal_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    NUMERIC_LITERAL(n, h);
  END LongReal_literal;


PROCEDURE Extended_literal(
    n: M3AST_AS_F.Extended_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    NUMERIC_LITERAL(n, h);
  END Extended_literal;


PROCEDURE Nil_literal(
    n: M3AST_AS_F.Nil_literal; h: AST_DisplayRep.Handle;
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "NIL", h);
  END Nil_literal;


PROCEDURE Text_literal(
    n: M3AST_AS_F.Text_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, M3CLiteral.ToText(n.lx_textrep), h);
  END Text_literal;


PROCEDURE Char_literal(
    n: M3AST_AS_F.Char_literal; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, M3CLiteral.ToText(n.lx_charrep), h);
  END Char_literal;


PROCEDURE Exp_used_id(
    n: M3AST_AS_F.Exp_used_id; h: AST_DisplayRep.Handle
    ) RAISES ANY=      
  BEGIN
    SSP_D(n, M3CId.ToText(n.vUSED_ID.lx_symrep), h);
  END Exp_used_id;


PROCEDURE Constructor(n: M3AST_AS_F.Constructor; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.CONS_ELEM;
    iter := SeqM3AST_AS_CONS_ELEM.NewIter(n.as_element_s);
    isFirst := TRUE;
  BEGIN
    SSP(n, h);
    h.Visit(n.as_type);
    SD("{", h);
    WHILE SeqM3AST_AS_CONS_ELEM.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_propagate # NIL THEN h.Visit(n.as_propagate); END;
    D("}", h);
  END Constructor;


PROCEDURE Propagate(
    n: M3AST_AS_F.Propagate; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, ", ..", h); 
  END Propagate;


PROCEDURE RANGE_EXP_elem(n: M3AST_AS_F.RANGE_EXP_elem; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_range_exp);
  END RANGE_EXP_elem;


PROCEDURE Actual_elem(n: M3AST_AS_F.Actual_elem; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    h.Visit(n.as_actual);
  END Actual_elem;

(*PRIVATE*)
PROCEDURE LowerPrec(child, parent: M3AST_AS.EXP; right: BOOLEAN
    ): BOOLEAN RAISES {}=
  VAR c_prec, p_prec: INTEGER;
  BEGIN
    (* Returns TRUE if child is lower precedence than parent 
      (and hence needs bracketing). 'right' denotes whether this
      is the right hand side, for which a bracket is needed
      if precedence is equal.
    *)

    (* parent is either a Binary or Unary; child may be any expression *)
    TYPECASE child OF
    | M3AST_AS.Binary(b) =>
        c_prec := BPrec(b.as_binary_op);
    | M3AST_AS.Unary(u) =>
        c_prec := UPrec(u.as_unary_op);
    ELSE
      RETURN FALSE
    END; (* if *)

    TYPECASE parent OF
    | M3AST_AS.Binary(b) =>
        p_prec := BPrec(b.as_binary_op);
    | M3AST_AS.Unary(u) =>
        p_prec := UPrec(u.as_unary_op);
    END; (* if *)

    RETURN c_prec < p_prec OR (right AND c_prec = p_prec);
  END LowerPrec;

(*PRIVATE*)
PROCEDURE BPrec(op: M3AST_AS.BINARY_OP): INTEGER RAISES {}=
  BEGIN
    TYPECASE op OF
    | M3AST_AS.Select => RETURN 10;

    | M3AST_AS.Times, M3AST_AS.Rdiv, 
      M3AST_AS.Div, M3AST_AS.Mod => RETURN 7;

    | M3AST_AS.Plus, M3AST_AS.Minus, M3AST_AS.Textcat => RETURN 6;

    | M3AST_AS.Eq, M3AST_AS.Ne, 
      M3AST_AS.Gt, M3AST_AS.Lt,
      M3AST_AS.Ge, M3AST_AS.Le, M3AST_AS.In => RETURN 5;
    
    | M3AST_AS.And => RETURN 3;

    | M3AST_AS.Or => RETURN 2;
    END; (* case *)
  END BPrec;

(*PRIVATE*)
PROCEDURE UPrec(op: M3AST_AS.UNARY_OP): INTEGER RAISES {}=
  BEGIN
    TYPECASE op OF
    | M3AST_AS.Deref => RETURN 9;

    | M3AST_AS.Unaryplus, M3AST_AS.Unaryminus => RETURN 8;

    | M3AST_AS.Not => RETURN 4;
    END; (* case *)
  END UPrec;


PROCEDURE Binary(n: M3AST_AS_F.Binary; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR bracket := FALSE;
  BEGIN
    SSP(n, h);
    IF LowerPrec(n.as_exp1, n, right := FALSE) THEN
      D("(", h); bracket := TRUE;
    END; (* if *)
    h.Visit(n.as_exp1);
    IF bracket THEN D(")", h); END;
    h.Visit(n.as_binary_op);
    bracket := FALSE;
    IF LowerPrec(n.as_exp2, n, right := TRUE) THEN
      D("(", h); bracket := TRUE;
    END; (* if *)
    h.Visit(n.as_exp2);
    IF bracket THEN D(")", h); END;
  END Binary;

PROCEDURE Plus(
    n: M3AST_AS_F.Plus; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "+", h);
  END Plus;


PROCEDURE Minus(
    n: M3AST_AS_F.Minus; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "-", h);
  END Minus;


PROCEDURE Times(
    n: M3AST_AS_F.Times; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "*", h);
  END Times;


PROCEDURE Rdiv(
    n: M3AST_AS_F.Rdiv; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "/", h);
  END Rdiv;


PROCEDURE Textcat(
    n: M3AST_AS_F.Textcat; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "&", h);
  END Textcat;


PROCEDURE Div(
    n: M3AST_AS_F.Div; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "DIV", h);
  END Div;


PROCEDURE Mod(
    n: M3AST_AS_F.Mod; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "MOD", h);
  END Mod;


PROCEDURE Eq(
    n: M3AST_AS_F.Eq; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "=", h);
  END Eq;


PROCEDURE Ne(
    n: M3AST_AS_F.Ne; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "#", h);
  END Ne;


PROCEDURE Gt(
    n: M3AST_AS_F.Gt; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, ">", h);
  END Gt;


PROCEDURE Lt(
    n: M3AST_AS_F.Lt; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "<", h);
  END Lt;


PROCEDURE Ge(
    n: M3AST_AS_F.Ge; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, ">=", h);
  END Ge;


PROCEDURE Le(
    n: M3AST_AS_F.Le; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "<=", h);
  END Le;


PROCEDURE And(
    n: M3AST_AS_F.And; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "AND", h);
  END And;


PROCEDURE Or(
    n: M3AST_AS_F.Or; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "OR", h);
  END Or;


PROCEDURE In(
    n: M3AST_AS_F.In; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_SDS(n, "IN", h);
  END In;


PROCEDURE Select(
    n: M3AST_AS_F.Select; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, ".", h);
  END Select;


PROCEDURE Unary(n: M3AST_AS_F.Unary; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR bracket := FALSE;
  BEGIN
    SSP(n, h);
    IF NOT ISTYPE(n.as_unary_op, M3AST_AS.Deref) THEN 
      h.Visit(n.as_unary_op);
    END;
    IF LowerPrec(n.as_exp, n, right := TRUE) THEN
      D("(", h); bracket := TRUE;
    END; (* if *)
    h.Visit(n.as_exp);
    IF ISTYPE(n.as_unary_op, M3AST_AS.Deref) THEN 
      h.Visit(n.as_unary_op);
    END;
    IF bracket THEN D(")", h); END;
  END Unary;


PROCEDURE Not(
    n: M3AST_AS_F.Not; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_DS(n, "NOT", h);
  END Not;


PROCEDURE Unaryplus(
    n: M3AST_AS_F.Unaryplus; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "+", h);
  END Unaryplus;


PROCEDURE Unaryminus(
    n: M3AST_AS_F.Unaryminus; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "-", h);
  END Unaryminus;


PROCEDURE Deref(
    n: M3AST_AS_F.Deref; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "^", h);
  END Deref;


PROCEDURE Call(n: M3AST_AS_F.Call; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Actual;
    iter := SeqM3AST_AS_Actual.NewIter(n.as_param_s);
    isFirst := TRUE;
  BEGIN
    SSP(n, h);
    h.Visit(n.as_callexp);
    D("(", h);
    WHILE SeqM3AST_AS_Actual.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    D(")", h);
  END Call;


PROCEDURE Index(n: M3AST_AS_F.Index; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.EXP;
    iter := SeqM3AST_AS_EXP.NewIter(n.as_exp_s);
    isFirst := TRUE;
  BEGIN
    SSP(n, h);
    h.Visit(n.as_array);
    D("[", h);
    WHILE SeqM3AST_AS_EXP.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    D("]", h);
  END Index;


PROCEDURE Actual(n: M3AST_AS_F.Actual; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP(n, h);
    IF n.as_id # NIL THEN h.Visit(n.as_id); SDS(":=", h); END;
    h.Visit(n.as_exp_type);
  END Actual;


PROCEDURE Assign_st(n: M3AST_AS_F.Assign_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_lhs_exp);
    SDS(":=", h);
    h.Visit(n.as_rhs_exp);
  END Assign_st;


PROCEDURE Call_st(n: M3AST_AS_F.Call_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent_SSP(n, h);
    h.Visit(n.as_call);
  END Call_st;


PROCEDURE Case_st(n: M3AST_AS_F.Case_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Case;
    iter := SeqM3AST_AS_Case.NewIter(n.as_case_s);
  BEGIN
    Indent(h);
    SSP_DS(n, "CASE", h);
    h.Visit(n.as_exp);
    SD("OF", h); NL(h);
    WHILE SeqM3AST_AS_Case.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
    Indent(h); 
    D("END", h); Tag(n, h);
  END Case_st;


PROCEDURE Eval_st(n: M3AST_AS_F.Eval_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_DS(n, "EVAL", h);
    h.Visit(n.as_exp);
  END Eval_st;


PROCEDURE Exit_st(
    n: M3AST_AS_F.Exit_st; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    Indent(h);
    SSP_D(n, "EXIT", h);
  END Exit_st;


PROCEDURE For_st(n: M3AST_AS_F.For_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_DS(n, "FOR", h);
    h.Visit(n.as_id); SDS(":=", h);
    h.Visit(n.as_from); SDS("TO", h);
    h.Visit(n.as_to);
    IF n.as_by # NIL THEN h.Visit(n.as_by); END;    
    SD("DO", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h); 
    D("END", h); Tag(n, h);
  END For_st;


PROCEDURE If_st(n: M3AST_AS_F.If_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Elsif;
    iter := SeqM3AST_AS_Elsif.NewIter(n.as_elsif_s);
  BEGIN
    Indent(h); SSP_DS(n, "IF", h);
    h.Visit(n.as_exp);
    SD("THEN", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h);
    WHILE SeqM3AST_AS_Elsif.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
    Indent(h); 
    D("END", h); Tag(n, h);
  END If_st;


PROCEDURE Lock_st(n: M3AST_AS_F.Lock_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h); SSP_DS(n, "LOCK", h);
    h.Visit(n.as_exp);
    SD("DO", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h);
    D("END", h); Tag(n, h);
  END Lock_st;


PROCEDURE Loop_st(n: M3AST_AS_F.Loop_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h); SSP_D(n, "LOOP", h);
    NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h);
    D("END", h); Tag(n, h);
  END Loop_st;


PROCEDURE Raise_st(n: M3AST_AS_F.Raise_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h); SSP_DS(n, "RAISE", h);
    h.Visit(n.as_qual_id);
    IF n.as_exp_void # NIL THEN 
      SD("(", h); h.Visit(n.as_exp_void); D(")", h); 
    END;
  END Raise_st;


PROCEDURE Repeat_st(n: M3AST_AS_F.Repeat_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_D(n, "REPEAT", h);
    NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h);
    DS("UNTIL", h);
    h.Visit(n.as_exp);
  END Repeat_st;


PROCEDURE Return_st(n: M3AST_AS_F.Return_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_DS(n, "RETURN", h);
    IF n.as_exp # NIL THEN h.Visit(n.as_exp); END;
  END Return_st;


PROCEDURE Try_st(n: M3AST_AS_F.Try_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h); SSP_D(n, "TRY", h);
    NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h);
    h.Visit(n.as_try_tail);
    Indent(h);
    D("END", h); Tag(n, h);
  END Try_st;


PROCEDURE Typecase_st(n: M3AST_AS_F.Typecase_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Tcase;
    iter := SeqM3AST_AS_Tcase.NewIter(n.as_tcase_s);
  BEGIN
    Indent(h);
    SSP_DS(n, "TYPECASE", h);
    h.Visit(n.as_exp);
    SD("OF", h); NL(h);
    WHILE SeqM3AST_AS_Tcase.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
    Indent(h);
    D("END", h); Tag(n, h);
  END Typecase_st;


PROCEDURE While_st(n: M3AST_AS_F.While_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_DS(n, "WHILE", h);
    h.Visit(n.as_exp);
    SD("DO", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h);
    D("END", h); Tag(n, h);
  END While_st;


PROCEDURE With_st(n: M3AST_AS_F.With_st; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Binding;
    iter := SeqM3AST_AS_Binding.NewIter(n.as_binding_s);
    isFirst := TRUE;
  BEGIN
    Indent(h);
    SSP_DS(n, "WITH", h);
    WHILE SeqM3AST_AS_Binding.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    SD("DO", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); Indent(h);
    D("END", h); Tag(n, h);
  END With_st;


PROCEDURE Block(n: M3AST_AS_F.Block; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.DECL_REVL;
    iter := SeqM3AST_AS_DECL_REVL.NewIter(n.as_decl_s);
  BEGIN
    SSP(n, h);
    WHILE SeqM3AST_AS_DECL_REVL.Next(iter, m) DO h.Visit(m); END;
    IF h.isModule THEN
      Indent(h);
      D("BEGIN", h);
      NLIncIndent(h);
    END; (* if *) 
    VisitSeqStm(n.as_stm_s, h);
    IF h.isModule THEN DecIndent(h); END;
    Indent(h); DS("END", h);
  END Block;


PROCEDURE Case(
    n: M3AST_AS_F.Case; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  VAR
    m: M3AST_AS.RANGE_EXP;
    iter := SeqM3AST_AS_RANGE_EXP.NewIter(n.as_case_label_s);
    isFirst := TRUE;
  BEGIN
    Indent(h);
    SSP_DS(n, "|", h);
    WHILE SeqM3AST_AS_RANGE_EXP.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    SDS("=>", h); IncIndent(h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); DecIndent(h); NL(h);
  END Case;

PROCEDURE Else_stm(n: M3AST_AS_F.Else_stm; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_D(n, "ELSE", h);
    NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h);
  END Else_stm;


PROCEDURE By(n: M3AST_AS_F.By; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP_SDS(n, "BY", h);
    h.Visit(n.as_exp);
  END By;


PROCEDURE Elsif(n: M3AST_AS_F.Elsif; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_DS(n, "ELSIF", h);
    h.Visit(n.as_exp);
    SD("THEN", h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h);
  END Elsif;


PROCEDURE Try_except(n: M3AST_AS_F.Try_except; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Handler;
    iter := SeqM3AST_AS_Handler.NewIter(n.as_handler_s);
  BEGIN
    Indent(h);
    SSP_D(n, "EXCEPT", h); 
    NL(h);
    WHILE SeqM3AST_AS_Handler.Next(iter, m) DO h.Visit(m); END;
    IF n.as_else # NIL THEN h.Visit(n.as_else); END;
  END Try_except;


PROCEDURE Try_finally(n: M3AST_AS_F.Try_finally; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    Indent(h);
    SSP_D(n, "FINALLY", h);
    NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h);
  END Try_finally;


PROCEDURE Tcase(n: M3AST_AS_F.Tcase; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.M3TYPE;
    iter := SeqM3AST_AS_M3TYPE.NewIter(n.as_type_s);
    isFirst := TRUE;
  BEGIN
    Indent(h);
    SSP_DS(n, "|", h);
    WHILE SeqM3AST_AS_M3TYPE.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_id # NIL THEN D("(", h); h.Visit(n.as_id); D(")", h); END;
    SDS("=>", h); IncIndent(h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); DecIndent(h); NL(h);
  END Tcase;


PROCEDURE Handler(n: M3AST_AS_F.Handler; h: AST_DisplayRep.Handle)
     RAISES ANY =
  VAR
    m: M3AST_AS.Qual_used_id;
    iter := SeqM3AST_AS_Qual_used_id.NewIter(n.as_qual_id_s);
    isFirst := TRUE;
  BEGIN
    Indent(h);
    SSP_DS(n, "|", h);
    WHILE SeqM3AST_AS_Qual_used_id.Next(iter, m) DO 
      Between(isFirst, CS, h); h.Visit(m); 
    END;
    IF n.as_id # NIL THEN D("(", h); h.Visit(n.as_id); D(")", h); END;
    SDS("=>", h); IncIndent(h); NLIncIndent(h);
    VisitSeqStm(n.as_stm_s, h);
    DecIndent(h); DecIndent(h); NL(h);
  END Handler;


PROCEDURE Binding(n: M3AST_AS_F.Binding; h: AST_DisplayRep.Handle)
     RAISES ANY =
  BEGIN
    SSP(n, h);
    h.Visit(n.as_id);
    SDS("=", h);
    h.Visit(n.as_exp);
  END Binding;


PROCEDURE External(
    n: M3AST_PG_F.External; h: AST_DisplayRep.Handle
    ) (*RAISES ANY*)=
  BEGIN
    SSP_DS(n, "<*EXTERNAL", h);
    IF n.lx_lang_spec # NIL THEN
      DS(M3CLiteral.ToText(n.lx_lang_spec), h);
    END;
    DS("*>", h);
  END External;

PROCEDURE Bad_EXP(
    n: M3AST_AS_F.Bad_EXP; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "<Bad_Exp>", h);
  END Bad_EXP;

PROCEDURE Bad_M3TYPE(
    n: M3AST_AS_F.Bad_M3TYPE; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    SSP_D(n, "<Bad_Type>", h); 
  END Bad_M3TYPE;

PROCEDURE Bad_STM(
    n: M3AST_AS_F.Bad_STM; h: AST_DisplayRep.Handle
    ) RAISES ANY=
  BEGIN
    Indent(h);
    SSP_D(n, "<Bad_Statement>", h);
  END Bad_STM;

BEGIN
END M3AST_AS_Display.
