MODULE M3PPIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, IO;
IMPORT M3PPSmarts, M3PPStream;
IMPORT M3AST_AS;
IMPORT AST_DisplayRep, M3ASTDisplay_handle;

IMPORT M3AST_AS_F;


CONST
  Indent_Size = 2;


PROCEDURE SSP_D(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error}=
  BEGIN
    EVAL M3PPSmarts.SeeIfStringFits(s, 0, h);
    (*IF n # NIL THEN n.lx_srcpos := M3PPStream.GetSrcPos(h.stream); END;*)
    IO.PutText(h.stream, s);
  END SSP_D;

PROCEDURE SSP_SD(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error}=
  BEGIN
    IF NOT M3PPSmarts.SeeIfStringFits(s, 1, h) THEN IO.Put(h.stream, ' ') END; 
    (*IF n # NIL THEN n.lx_srcpos := M3PPStream.GetSrcPos(h.stream); END;*)
    IO.PutText(h.stream, s);
  END SSP_SD;

PROCEDURE SSP_DS(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error}=
  BEGIN
    EVAL M3PPSmarts.SeeIfStringFits(s, 1, h);
    (*IF n # NIL THEN n.lx_srcpos := M3PPStream.GetSrcPos(h.stream); END;*)
    IO.PutText(h.stream, s);
    IO.Put(h.stream, ' ');
  END SSP_DS;

PROCEDURE SSP_SDS(
    n: M3AST_AS.SRC_NODE;
    s: Text.T;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error}=
  BEGIN
    IF NOT M3PPSmarts.SeeIfStringFits(s, 2, h) THEN IO.Put(h.stream, ' ') END;
    (*IF n # NIL THEN n.lx_srcpos := M3PPStream.GetSrcPos(h.stream); END;*)
    IO.PutText(h.stream, s);
    IO.Put(h.stream, ' ');
  END SSP_SDS;

PROCEDURE SSP(
    n: M3AST_AS.SRC_NODE; h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    (*n.lx_srcpos := M3PPStream.GetSrcPos(h.stream);*)
  END SSP;

PROCEDURE D(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    SSP_D(NIL, s, h);
  END D;

PROCEDURE SD(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    SSP_SD(NIL, s, h);
  END SD;

PROCEDURE DS(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    SSP_DS(NIL, s, h);
  END DS;

PROCEDURE SDS(s: Text.T; h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    SSP_SDS(NIL, s, h);
  END SDS;

PROCEDURE SCNL(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IO.Put(h.stream, ';'); NL(h);
  END SCNL;

PROCEDURE CS(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IO.Put(h.stream, ','); IO.Put(h.stream, ' ');
  END CS;

PROCEDURE SCS(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IO.Put(h.stream, ';'); IO.Put(h.stream, ' ');
  END SCS;

PROCEDURE Indent(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  VAR
    k: CARDINAL;
  BEGIN
    IF M3PPSmarts.IsNLSuppressed(h) THEN RETURN END;
    FOR k := 1 TO h.indent DO
      IO.Put(h.stream, ' ');
    END; (* for *)
  END Indent;

PROCEDURE Indent_SSP(
    n: M3AST_AS.SRC_NODE;
    h: AST_DisplayRep.Handle)
    RAISES {IO.Error}=
  BEGIN
    Indent(h);
  END Indent_SSP;

PROCEDURE NLIncIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    NL(h); IncIndent(h);
  END NLIncIndent;

PROCEDURE NLDecIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    NL(h); DecIndent(h);
  END NLDecIndent;

PROCEDURE IncIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    INC(h.indent, Indent_Size);
  END IncIndent;

EXCEPTION IndentUnderflow;

PROCEDURE DecIndent(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IF h.indent < Indent_Size THEN RAISE IndentUnderflow; END;
    DEC(h.indent, Indent_Size);
  END DecIndent;

PROCEDURE NL(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IO.Put(h.stream, '\n');
    M3PPSmarts.ResetLineBreak(h);
  END NL;

PROCEDURE NL2(h: AST_DisplayRep.Handle) RAISES {IO.Error}=
  BEGIN
    IO.PutText(h.stream, "\n\n");
    M3PPSmarts.ResetLineBreak(h);
  END NL2;


BEGIN
END M3PPIO.
