INTERFACE M3PPSmarts;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* This module implements some smarts which try to place a sub-tree on
   a single line. *)

IMPORT M3AST_AS;
IMPORT ASTWalk;
IMPORT AST_DisplayRep;


PROCEDURE CheckNLSuppress(
    n: M3AST_AS.SRC_NODE; 
    vm: ASTWalk.VisitMode;
    h: AST_DisplayRep.Handle;
    ) RAISES {};
(* Should be called on VEntry to a node which should be printed on a single
line if it will fit.  It should also be called on VExit from the node.
*)

PROCEDURE IsNLSuppressed(h: AST_DisplayRep.Handle): BOOLEAN RAISES {};
(* TRUE if NL suppression is enabled. *)

PROCEDURE SeeIfStringFits(
    s: TEXT; wsc: CARDINAL; h: AST_DisplayRep.Handle): BOOLEAN
    RAISES {};
(* Check if we need a line break before outputting 's' + 'wsc' white-space
   chars, and do it if required and return TRUE, else return FALSE. 
*)

PROCEDURE SeeIfNodeFits(an: M3AST_AS.SRC_NODE; 
    h: AST_DisplayRep.Handle) RAISES {};
(* Check if we need a line break before outputting sub-tree 'an'.
*)

PROCEDURE ResetLineBreak(h: AST_DisplayRep.Handle) RAISES {};
(* Undoes any line break magic; call when a real newline occurs *)

END M3PPSmarts.
