INTERFACE M3PPStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO;
IMPORT M3CSrcPos;

TYPE T <: IO.Stream;

PROCEDURE Open(s: IO.Stream): T RAISES {};
(* Open a counting stream backed by 's'.
*)

<*INLINE*> PROCEDURE GetSrcPos(s: T): M3CSrcPos.T RAISES {};
(* Return the current source position on stream 's'.
*)

<*INLINE*> PROCEDURE PutSrcPos(s: T; t:  M3CSrcPos.T) RAISES {};
(* (Re)Set the current source position on stream 's'.
*)

<*INLINE*> PROCEDURE NLToSpace(s: T; set: BOOLEAN) RAISES {};
(* Temporarily transforms newlines into spaces if 'set=TRUE'.
   Resets to normal if 'set=FALSE'.
*)

PROCEDURE Suppress(s: T; set: BOOLEAN;
    VAR (*inout*) t: M3CSrcPos.T) RAISES {};
(* Temporarily suppress output if 'set=TRUE'; Also t := GetSrcPos(s);
   Resets to normal if 'set=FALSE'.  Also SetSrcPos(t);
*)

END M3PPStream.
