(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE M3DepMFTool;

IMPORT Fmt, M3Args;

VAR
  tool_g: M3Args.T;

(*PUBLIC*)
PROCEDURE Get(): M3Args.T RAISES {}=
  BEGIN RETURN tool_g; END Get;

BEGIN
  tool_g := M3Args.New(Name, "Modula-3 Makefile Generator", Version);
  M3Args.RegisterStringList(
      tool_g, DefineMacros_Arg, "define macro value(s)", M3Args.Opt.Optional);
  M3Args.RegisterString(
      tool_g,
      MakeFile_Arg,
      Fmt.F(
          "name of makefile; default is \'%s\',\nuse \'%s\' for stdout",
          MakeFileDefault,
          StdOut_Arg),
      M3Args.Opt.Optional);
  M3Args.RegisterString(tool_g, AR_Arg, 
    "make archive file target with name \'lib<name>\'.a");
  M3Args.RegisterFlag(tool_g, Gdebug_Arg, 
    "set default compile flags to \'-g\'");
  M3Args.RegisterFlag(tool_g, LocalModulesOnly_Arg, 
      "no non-local modules => no program targets generated");
  M3Args.RegisterFlag(tool_g, Verbose_Arg, "be verbose");

  M3Args.MarkShared(Gdebug_Arg);
  M3Args.MarkShared(AR_Arg);
  M3Args.MarkShared(LocalModulesOnly_Arg);
  M3Args.MarkShared(Verbose_Arg);



END M3DepMFTool.
