INTERFACE M3Extension;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;


(* There are a number of extensions commonly used by the M3 system. These
extensions are given an enumeration type for convenience *)
TYPE
  T =
    {Int,	(* interface source *)
     IntG,      (* generic interface source *)
     PInt,	(* pickled interface (AST) *)
     IntPp,	(* un-preprocessed interface source *)
     Mod,	(* module source *)
     ModG,      (* generic module source *)
     PMod,	(* pickled module (AST)  *)
     ModPp,	(* un-preprocessed module source *)
     PModR,	(* pickled module, reduced AST *)
     PIntR,	(* pickled interface, reduced AST *)
     MObj,      (* (module) object *)
     IObj,      (* (interface) object *)
     Exe,	(* executable *)
     MC,	(* (module) C intermediate *)
     IC,        (* (interface) C intermediate *)
     MAsm,	(* (module) assembly code *)
     IAsm,      (* (interface) assembly code *)
     ObjLib,    (* object library *)
     Tmp,	(* temporary file *)
     Null,	(* no extension *)
     Obj,	(* = MObj (deprecated) *)
     C,         (* = MC (deprecated) *)
     Asm};      (* = MAsm (deprecated) *)
  TSet = SET OF T;

CONST
  Ints = TSet{T.Int, T.IntG};
  Mods = TSet{T.Mod, T.ModG};

(* deprecated namesd are accepted as arguments, but never returned as 
results *)

PROCEDURE ToText(t: T): Text.T RAISES {};
PROCEDURE FromText(text: Text.T; VAR t: T): BOOLEAN RAISES {};
(* conversion from the enumeration 'T' to texts and back *)

PROCEDURE Extend(name: Text.T; t: T): Text.T RAISES {};
(* adds the given extension to the given path name. Any previous extension is
removed. If the extension is 'T.Null' the effect is to remove any existing
extension *)

PROCEDURE Has(
    name: Text.T;
    VAR t: T)
    : BOOLEAN
    RAISES {};
(* is 'name' extended by one of the Modula 3 special extensions? If so return
TRUE and set 't' to be the extension. If the file has no extension 't' is
set to 'T.Null' and TRUE is returned. If the file has an extension but it is
not one of the special ones 't' is left unchanged and FALSE is returned *)

END M3Extension.

