INTERFACE M3Files;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO, M3Extension, Text;


PROCEDURE Open(
    name: Text.T;
    ext: M3Extension.T;
    mode: IO.OpenMode)
    : IO.Stream
    RAISES {IO.Error};
(* open the file corresponding to module 'name' with m3 extension 'ext'. Open
with the given stream mode. Return the resulting stream.  If there is no such
file, the stream returned is NIL.  If there is such a file, but there is an
error opening it, then IO.Error is raised. *)

END M3Files.
