INTERFACE M3CToken;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT CharType;


TYPE
  T = {ADDRESS_, AND_, ANY_, ARRAY_, AS_, BEGIN_, BITS_, BRANDED_, BY_, CASE_, 
      CONST_, DIV_, DO_, ELSE_, ELSIF_, END_, EVAL_, EXCEPT_, EXCEPTION_, 
      EXIT_, EXPORTS_, EXTENDED_, FINALLY_, FOR_, FROM_, GENERIC_, IF_, 
      IMPORT_, IN_, INTEGER_, INTERFACE_,
      LOCK_, LONGREAL_, LOOP_, METHODS_, MOD_, MODULE_, NIL_, NOT_, NULL_,
      OBJECT_, OF_, OR_, OVERRIDES_, PROCEDURE_, RAISE_, RAISES_, 
      READONLY_, REAL_,
      RECORD_, REF_, REFANY_, REPEAT_, RETURN_, REVEAL_, ROOT_, SET_, THEN_,
      TO_, TRY_, TYPE_, TYPECASE_, UNSAFE_, UNTIL_, UNTRACED_, VALUE_, VAR_,
      WHILE_, WITH_,
      Identifier,
      CharLiteral, TextLiteral, IntegerLiteral, RealLiteral, LongRealLiteral,
      ExtendedLiteral, Plus, Minus, Times, Divide,
      Equal, NotEqual,
      LessThan, GreaterThan, LessThanOrEqual, GreaterThanOrEqual,
      Ampersand, Dereference, Dot,
      Bra, Ket, CurlyBra, CurlyKet, SquareBra, SquareKet,
      Becomes,
      Semicolon, Comma, Colon, Bar, Range, Subtype, Implies,
      Void};
  Set = SET OF T;

  ReservedWord = [T.ADDRESS_..T.WITH_];
  Literal = [T.CharLiteral..T.ExtendedLiteral];


CONST
  ReservedWords = Set{FIRST(ReservedWord)..LAST(ReservedWord)};
  Literals = Set{FIRST(Literal)..LAST(Literal)};

  Backslash = '\134';
  (* a bad character is one that cannot appear at the start of a token *)
  PrintableBadChars =
      CharType.Set{'!', '$', '%', '?', '@', Backslash, '_', '`', '~'};
  GoodChars = CharType.Printable - PrintableBadChars;
  BadChars = CharType.All - GoodChars;


END M3CToken.
