UNSAFE MODULE M3ASTCacheTool;

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

IMPORT RTHeap, RTHeapRep;
IMPORT SmallIO;
IMPORT TimeElapsed;
IMPORT TextTo;
IMPORT M3Args;
IMPORT M3CGoList, M3CUnit, M3Conventions, M3Context;
IMPORT M3AST_AS;

CONST Version = "29-Sep-92";

VAR tool_g := M3Args.New("m3astcache", "AST cache tool", Version);
    size_g := 0;
    notify_g := FALSE;

PROCEDURE Check() RAISES {}=
  VAR size: TEXT; card: CARDINAL;
  BEGIN
    IF M3Args.Find(tool_g) THEN
      size := M3Args.GetString(tool_g, ASTCache_Arg);
      IF size # NIL THEN
      	IF TextTo.BigCard(size, card) THEN
          EVAL Increase(card);
        END; (* if *)
      END; (* if *)
      RTHeapRep.RegisterMonitor(NEW(MonitorClosure));
      IF M3Args.GetFlag(tool_g, NotifyGC_Arg) THEN
        notify_g := TRUE;
      END; (* if *)
      IF M3Args.GetFlag(tool_g, DisableGC_Arg) THEN
        RTHeap.DisableCollection()  
      END; (* if *)
      IF M3Args.GetFlag(tool_g, DiscardModules_Arg) THEN
        M3CGoList.AddNotification(NEW(NotificationClosure));
      END;
    END; (* if *)
  END Check;

PROCEDURE Handle(): M3Args.T RAISES {}=
  BEGIN
    RETURN tool_g;
  END Handle;

PROCEDURE Current(): CARDINAL RAISES {}=
  BEGIN
    RETURN size_g;
  END Current;

PROCEDURE Increase(n: CARDINAL): CARDINAL RAISES {}=
  TYPE Store = REF ARRAY OF CHAR;
  VAR store := NEW(Store, n);
  BEGIN
    (* allocate it and throw it away *)
    store := NIL;
    INC(size_g, n);
    RETURN size_g;
  END Increase;


PROCEDURE Notify(b: BOOLEAN) RAISES {}=
  BEGIN
    notify_g := b;
  END Notify;

TYPE
  MonitorClosure = RTHeapRep.MonitorClosure OBJECT
    start: INTEGER;
  OVERRIDES
    before := Before;
    after := After;
  END;

PROCEDURE Before(cl: MonitorClosure) RAISES {}=
  BEGIN
    IF notify_g THEN
      cl.start := TimeElapsed.CPU();
      SmallIO.PutText(SmallIO.stdout, "\nGarbage collecting...");
    END;
  END Before;

PROCEDURE After(cl: MonitorClosure) RAISES {}=
  BEGIN
    IF notify_g THEN
      WITH el= TimeElapsed.CPU() - cl.start DO
        WITH out = SmallIO.stderr DO
          SmallIO.PutText(out, "done in ");
          SmallIO.PutInt(out, el DIV 100);
          SmallIO.PutChar(out, '.');
          SmallIO.PutInt(out, el MOD 100);
          SmallIO.PutChar(out, '\n');
        END;
      END;          
    END;
  END After;

TYPE
  NotificationClosure = M3CGoList.Notification OBJECT
  OVERRIDES
    notify := CheckDiscard
  END;

PROCEDURE CheckDiscard(           cl: NotificationClosure;
                             c   : M3Context.T;
                             nm  : M3CGoList.NotifyMode;
                             name: TEXT;
                             ut  : M3CUnit.Type;
                  <*UNUSED*> uf  : M3CUnit.Form;
                  <*UNUSED*> cu  : M3AST_AS.Compilation_Unit;
                  <*UNUSED*> ct  : M3Conventions.CompTime     ) =
  BEGIN
    IF M3Args.GetFlag(tool_g, DiscardModules_Arg)
         AND nm = M3CGoList.NotifyMode.After
         AND ut = M3CUnit.Type.Module THEN
      M3Context.Remove(c, name, ut) END
  END CheckDiscard;

BEGIN
  M3Args.RegisterString(tool_g, ASTCache_Arg,
      "pre-allocate 'n' bytes of heap, e.g. 32M");
  M3Args.RegisterFlag(tool_g, NotifyGC_Arg,
      "notify about garbage collections to stderr");
  M3Args.RegisterFlag(tool_g, DisableGC_Arg,
      "disable garbage collection");
  M3Args.RegisterFlag(
    tool_g, DiscardModules_Arg, "discard modules after compilation");

END M3ASTCacheTool.




