(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3ToolFrame;

(* Basic framework for an AST-based tool. *)

IMPORT M3Context;

PROCEDURE Init(c: M3Context.T): INTEGER;
(* 
  This procedure is equivalent to the following boilerplate:

  BEGIN
    M3CBE_C_Tool.ToolInit();             (* register target machine variants *)
    IF M3Args.CheckHelp() THEN RETURN 0 END; (* check for -help *)
    IF M3CBE_C_Tool.Init() < 0 THEN RETURN -1 END; (* fail if bad target *)
    M3DPathTool.Check();                 (* check for -D path *)
    M3ASTCacheTool.Check();              (* check for -ASTCache n *)
    WiredStandard.Set(context);          (* include "standard" interface *)
    RETURN 1
  END;

  I.e. it returns < 0 if an initialisation error occurs, 0 if help
  was requested and > 0 otherwise.
*)

TYPE 
  WorkProc = PROCEDURE(
       context: M3Context.T;
       compileResult: INTEGER): INTEGER RAISES ANY;

PROCEDURE Startup(
    worker: WorkProc;
    compile := TRUE;
    ): INTEGER RAISES ANY;
(*
  This procedure is equivalent to the following boilerplate:
  VAR
    context := M3Context.New();
    compileResult: INTEGER := Init(context);
  BEGIN
    IF compileResult <= 0 THEN RETURN compileResult END;
    IF compile THEN compileResult := M3CFETool.CompileInContext(context) END;
    RETURN worker(context, compileResult);        (* call user procedure *)
  END;
*)


END M3ToolFrame.
