(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3ContextRemove;

IMPORT M3Context, M3CUnit;

PROCEDURE Units(
    context: M3Context.T;
    READONLY units: ARRAY OF TEXT;
    ut: M3CUnit.Type;
    cl: M3Context.Closure := NIL;
    ) RAISES {};
(* Remove the 'units' of type 'ut' from 'context', plus all units which
reference these, transitively. If 'cl # NIL' then 'cl.callback' will be
called for each dependent unit that is removed. *)

PROCEDURE UnitsWithErrors(
    context: M3Context.T;
    cl: M3Context.Closure := NIL
    ) RAISES {};
(* as 'Units' but remove those units with compilation errors. *)

END M3ContextRemove.
