(* Distributed only by permission. *)
(* Last modified on Wed Aug  5 12:55:07 PDT 1992 by broder  *)
(*      modified on Tue Aug 4 20:22:22 PDT 1992 by guarino *)
(* modified on Tue Jul 21 06:43:42 1992 by mhb *)

MODULE PrefixView;
IMPORT StringSearchViewClass, View, ZeusPanel, Grid, Text, MG, MGV, Font,
       Scale, ViewsBase, PaintOpCache, PaintOp, ColorName, VBT, Filter;


CONST
  RectSize = 20.0;
  InitSize = 12;

TYPE
  T = StringSearchViewClass.T OBJECT
        grid: Grid.V;
        pat : TEXT;
        m   : CARDINAL;         (* Length of pattern *)
      OVERRIDES
        oeKMPSetup := KMPSetup;
        oeAddEdge  := AddEdge;
      END;

VAR 
  PartialCS := PaintOpCache.MakeColorScheme(
                 fg := PaintOp.Fg,
                 bg := PaintOpCache.FromRGB(
                         ColorName.ToRGB(ViewsBase.PartialC)));

PROCEDURE KMPSetup (self: T; p: TEXT) =
  VAR
    m := Text.Length(p);
    g := NEW(Grid.V).init(m, m, RectSize, RectSize);
  BEGIN
    LOCK VBT.mu DO EVAL Filter.Replace(self, NEW(Scale.T).init(g)) END;
    self.pat := p;
    self.m := m;
    self.grid := g;
    LOCK g.mu DO
      FOR i := 0 TO m - 1 DO
        FOR j := 0 TO m - 1 DO g.a[i, j].setVisible(g, 0.0); END;
      END;
      FOR i := 0 TO m - 1 DO
        FOR j := 0 TO i DO
          g.a[i, j].setVisible(g, 1.0);
          g.a[i, j].setLabel(g, Text.Sub(p, j, 1));
          g.a[i, j].setFont(
            g, Font.FromName(
                 ARRAY OF TEXT{"-*-courier-bold-r-*-*-*-180-*-*-*-*-*-*"}));
        END;
      END;
    END;
    MGV.Animation(g);
  END KMPSetup;

PROCEDURE AddEdge (self: T; f, t: CARDINAL) =
  BEGIN
    FOR i := 1 TO t DO
      self.grid.a[f - 1, f - i].setColor(self.grid, PartialCS)
    END;
    MGV.Animation(self.grid);
  END AddEdge;

PROCEDURE New (): View.T =
  VAR g := NEW(Grid.V).init(InitSize, InitSize, RectSize, RectSize);
  BEGIN
    FOR i := 0 TO InitSize - 1 DO
      FOR j := 0 TO InitSize - 1 DO g.a[i, j].setVisible(g, 0.0); END;
    END;
    RETURN NEW(T, grid := g).init(NEW(Scale.T).init(g));
  END New;

BEGIN
  ZeusPanel.RegisterView(New, "Prefix", "StringSearch");
END PrefixView.

