(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Thu Sep 24 14:46:33 PDT 1992 by mhb *)
(*      modified on Tue Aug  4 14:09:04 PDT 1992 by guarino *)

MODULE TouchView;
IMPORT ColorName, FormsVBT, PaintOp, PaintOpCache, Rd,
       StringSearchViewClass, TextEditVBT, TextPort, TextPortPrivate,
       Thread, VBT, View, VTDef, VText, ZeusPanel;


TYPE
  T = StringSearchViewClass.T OBJECT
        form : FormsVBT.T;
        port : TextPort.T;
        interval: VText.Interval := NIL;
        l, r: CARDINAL := 0;
      OVERRIDES
        oeSetup         := Setup;
        oeProbe         := Probe;
      END;

VAR

  Black     := PaintOpCache.FromRGB(ColorName.ToRGB("Black"));
  Yellow     := PaintOpCache.FromRGB(ColorName.ToRGB("Yellow"));

  present := MakeHighlight(Black, Yellow);


PROCEDURE VTError(code: VTDef.ErrorCode):TEXT =
BEGIN
  CASE code OF
  | VTDef.ErrorCode.IsNil => RETURN("NIL vtext");
  | VTDef.ErrorCode.IllegalIndex => RETURN("Illegal index ");
  | VTDef.ErrorCode.IllegalRegion => RETURN("Illegal region");
  | VTDef.ErrorCode.IllegalCoord => RETURN("Illegal coordinate");
  | VTDef.ErrorCode.IllegalDividers => RETURN("Illegal dividers");
  | VTDef.ErrorCode.IllegalFont => RETURN("Illegal font");
  | VTDef.ErrorCode.Closed => RETURN("vtext already closed");
  ELSE RETURN("unknown VTDef.ErrorCode")
  END;
END VTError;

PROCEDURE MakeHighlight (fg, bg: PaintOp.T): VText.IntervalOptions =
  BEGIN
    WITH cs = PaintOpCache.MakeColorScheme (fg := fg, bg:= bg) DO
      RETURN VText.MakeIntervalOptions (
               VText.IntervalStyle.HighlightStyle, cs, cs, cs.bg)
    END
  END MakeHighlight;

PROCEDURE Setup (view: T; pattern, target: TEXT) =
  BEGIN
    LOCK VBT.mu DO
      TRY
        FormsVBT.PutText(view.form, "text", target);
        FormsVBT.PutText(view.form, "pattern", pattern);
        FormsVBT.PutInteger(view.form, "probeCount", 0);
        view.interval := NIL;
        VBT.Mark(view.port);
      EXCEPT
      | FormsVBT.Error (msg) => ZeusPanel.ReportError(msg);
      | FormsVBT.Unimplemented =>
          ZeusPanel.ReportError("FormsVBT.Unimplemented in MGRdView.Setup");
      | VTDef.Error (code) => ZeusPanel.ReportError(VTError(code));
      END;
    END;
  END Setup;

PROCEDURE Probe (view: T; i, n: CARDINAL) =
  BEGIN
    TRY
      FormsVBT.PutInteger(view.form, "probeCount",
                          FormsVBT.GetInteger(view.form, "probeCount") + 1);
     (* this scheme is not foolproof for avoiding overlapping intervals *)
      IF view.interval # NIL AND n = view.l - 1 THEN
        VText.MoveInterval(view.interval, n, view.r);
        DEC(view.l);
      ELSIF view.interval # NIL AND n = view.r THEN
        VText.MoveInterval(view.interval, view.l, n + 1);
        INC(view.r);
      ELSIF view.interval = NIL OR n < view.l OR n > view.r THEN
        view.interval :=
          VText.CreateInterval(view.port.vtext, n, n + 1, present);
        VText.SwitchInterval(view.interval, VTDef.OnOffState.On);
        view.l := n;
        view.r := n + 1;
      END;
      VBT.Mark(view.form);
    EXCEPT
    | Rd.Failure => ZeusPanel.ReportError("Rd.Failure in Probe");
    | Rd.EndOfFile => ZeusPanel.ReportError("Rd.EndOfFile in Probe");
    | FormsVBT.Error (msg) => ZeusPanel.ReportError(msg);
    | FormsVBT.Unimplemented =>
        ZeusPanel.ReportError("FormsVBT.Unimplemented in MGRdView.Probe");
    | VTDef.Error (code) => ZeusPanel.ReportError(VTError(code));
    END;
  END Probe;

PROCEDURE New (): View.T =
  VAR
    f       : FormsVBT.T;
    textedit: TextEditVBT.T;
  BEGIN
    TRY
      f := NEW(FormsVBT.T).initFromRsrc(
             "stringsearchtextview.fv", ZeusPanel.GetPath());
      textedit := FormsVBT.GetVBT(f, "text");
      RETURN NEW(T, form := f, port := textedit.port).init(f);
    EXCEPT
    | Rd.Failure =>
        ZeusPanel.ReportError("Rd.Failure in MGRdView.New");
    | Thread.Alerted =>
        ZeusPanel.ReportError("Thread.Alerted in MGRdView.New");
    | FormsVBT.Error (msg) => ZeusPanel.ReportError(msg);
    | FormsVBT.Unimplemented =>
        ZeusPanel.ReportError(
          "FormsVBT.Unimplemented in MGRdView.New");
    | VTDef.Error (code) => ZeusPanel.ReportError(VTError(code));
    END;
    RETURN (NIL);
  END New;

BEGIN
  ZeusPanel.RegisterView (New, "Touched", "StringSearch");
END TouchView.
