(* Test: more of the Thread interface *)

MODULE Main;

IMPORT Wr, Thread, Stdio, Text, Time;
FROM Test IMPORT done;
<*FATAL ANY*>

TYPE
  T = Thread.Closure BRANDED "p007 T" OBJECT
	id: Text.T; 
	pause: INTEGER := 0;
        limit: INTEGER := 50;
      OVERRIDES
	apply := Task;
	END;

VAR
  j: INTEGER;

PROCEDURE Task (self: T) : REFANY RAISES {} =
VAR
  x, y: REAL;

BEGIN
  IF self.pause # 0 THEN
    Time.LongPause (self.pause); END;
  FOR i := 0 TO self.limit DO
    FOR i := 1 TO 5000 DO
      x := 3.12445; y := 87.324; y := y * x; END; 
    Wr.PutText (Stdio.stdout, self.id); 
    INC (j);
    IF (j > 25) THEN
      j := 0;
      Wr.PutText (Stdio.stdout, "\n"); END; END;
  Wr.PutText (Stdio.stdout, "\ndone with " & self.id & "\n");
  RETURN NIL;
END Task;

VAR
  t1, t2, t3: T;
  th1, th2, th3: Thread.T;

BEGIN

t1 := NEW (T, id := "A ");
t2 := NEW (T, id := "B ");
t3 := NEW (T, id := "C ", pause := 25);

th1 := Thread.Fork (t1);
th2 := Thread.Fork (t2);
th3 := Thread.Fork (t3);

EVAL Thread.Join (th1);
EVAL Thread.Join (th2);
EVAL Thread.Join (th3);

done ();

END Main.
