MODULE Main;

IMPORT ParseParams, RTParams, Wr, Stdio, Fmt;
<*FATAL ANY*>

VAR t: TEXT;
VAR wr := Stdio.stdout;
BEGIN
  Wr.PutText (wr, Fmt.Int (ParseParams.NumParameters));
  Wr.PutText (wr, " params\n\n");

  FOR i := 0 TO ParseParams.NumParameters-1 DO
    Wr.PutText (wr, Fmt.Int (i));
    Wr.PutText (wr, ": ");
    Wr.PutText (wr, ParseParams.GetParameter (i));
    Wr.PutText (wr, "\n");
  END;
  Wr.PutText (wr, "\n");

  Wr.PutText (wr, Fmt.Int (RTParams.NumParameters));
  Wr.PutText (wr, " runtime params\n\n");

  FOR i := 0 TO RTParams.NumParameters-1 DO
    Wr.PutText (wr, Fmt.Int (i));
    Wr.PutText (wr, ": ");
    Wr.PutText (wr, RTParams.Nth (i));
    Wr.PutText (wr, "\n");
  END;
  Wr.PutText (wr, "\n");

  Wr.PutText (wr, "RTParams.Present (xyz) => ");
  Wr.PutText (wr, Fmt.Bool (RTParams.IsPresent ("xyz")));
  Wr.PutText (wr, "\n");

  Wr.PutText (wr, "RTParams.Value (xyz) => ");
  t := RTParams.Value ("xyz");
  IF (t = NIL)
    THEN Wr.PutText (wr, "NIL");
    ELSE Wr.PutChar (wr, '"'); Wr.PutText (wr, t);  Wr.PutChar (wr, '"');
  END;
  Wr.PutText (wr, "\n");

END Main.
