(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* VBTReceiver.def, by gnelson and msm. *)
<*PRAGMA LL*>

(* Last modified on Mon Feb 24 13:51:27 PST 1992 by muller  *)
(*      modified on Thu May 26 19:50:46 PDT 1988 by gnelson *)

SAFE DEFINITION MODULE VBTReceiver;

(* Parent side of cross-address space VBT filter.

   A cross-address space VBT is a filter in which the parent and child
   are in different address spaces. The filter has no effect except to
   transport events between the address spaces. For example, the ivy
   text editor can use cross-address space VBTs to manage text
   subwindows of applications in other address spaces.

   This is the interface that you use to create a filter in which the
   parent VBT is in your address space and the child is in a remote
   address space (called the provider). You identify the provider by two
   Text.Ts (see the interface VBTProvider for more details). You pass a
   Text.T to the provider to specify the kind of child VBT that you want
   it to provide. The interpretation of the Text.T is up to you and the
   provider.

   Index: VBT, cross-address space *)

IMPORT Text, VBT, RPC;

TYPE
  Instance = REF;

PROCEDURE Import(
    instance, subinstance: Text.T;
    localOnly: BOOLEAN := FALSE)
    : Instance
  RAISES {RPC.ImportFailed};
(* Locates and returns the VBT provider identified by instance and
   subinstance. Typically, instance is the name of the machine providing
   the service, and subinstance identifies the type of service, e.g.
   "IvyVBT" *)

PROCEDURE New(
    inst: Instance;
    t: Text.T)
    : VBT.T
  RAISES {VBT.Error, RPC.CallFailed};
(* Ask the VBT provider inst to create a child VBT determined by t,
   connect it via a cross-address space filter to a parent VBT in this
   address space, and return the parent. Relays errors generated by RPC
   or by the provider. *)

END VBTReceiver.
