(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Thu Oct 15 16:01:10 PDT 1992 by msm *)
(* modified on Mon Feb 24 13:57:19 PST 1992 by muller *)
(* modified on Fri Sep 6 17:25:31 PDT 1991 by gnelson *)
<*PRAGMA LL*>

(* Every installed VBT has a DpyFilter above it to catch messages telling
   the window to move to a new display. *)

MODULE DpyFilter;

IMPORT VBT, Filter, InstalledVBT, Trestle, TrestleComm, TextToRefanyTable,
       Point, MiscDetail, VBTClass, Thread, Split, Rd, Filename, FileStream,
       Env, TrestleGoo, Text;

REVEAL
  T = Public BRANDED OBJECT
        enabled        := TRUE;
        expectedDelete := FALSE
      OVERRIDES
        misc := Misc;
        init := Init
      END;

VAR
  mu     := NEW(Thread.Mutex);
  inited := FALSE;

PROCEDURE Init (v: T; ch: VBT.T; enabled: BOOLEAN): T =
  BEGIN
    LOCK mu DO
      IF NOT inited THEN
        ChangeDisplay := VBT.GetMiscCodeType("ChangeDisplay");
        inited := TRUE
      END
    END;
    v.enabled := enabled;
    EVAL Filter.T.init(v, ch);
    RETURN v
  END Init;

PROCEDURE New (ch: VBT.T; enabled := TRUE): T =
  VAR res := NEW(T);
  BEGIN
    EVAL res.init(ch, enabled);
    RETURN res
  END New;

VAR trsls := TextToRefanyTable.New();

PROCEDURE Connect (servers: REF ARRAY OF TEXT): Trestle.T =
  VAR
    res: Trestle.T;
    ra : REFANY;
  BEGIN
    FOR i := FIRST(servers^) TO LAST(servers^) DO
      IF trsls.in(servers[i], ra) THEN RETURN ra END
    END;
    FOR i := FIRST(servers^) TO LAST(servers^) DO
      TRY
        res := Trestle.Connect(servers[i]);
        EVAL trsls.put(servers[i], res);
        RETURN res
      EXCEPT
        TrestleComm.Failure =>  (* skip *)
      END
    END;
    RETURN NIL
  END Connect;

TYPE Password = BRANDED REF RECORD pass: TEXT END;

VAR
  DefaultPassword: TEXT := NIL;
  pInited                := FALSE;
  iMu                   := NEW(MUTEX);

PROCEDURE Misc (v: T; READONLY cd: VBT.MiscRec) =
  <* FATAL Split.NotAChild *>
  BEGIN
    IF v.enabled AND cd.type = ChangeDisplay THEN
      VAR
        ch             := InstalledVBT.Child(v);
        m   : Message  := MiscDetail.ToRef(cd.detail[0]);
        d              := MiscDetail.ToRef(cd.detail[1]);
        trsl           := Connect(m.newDisplay);
        pw  : Password := VBT.GetProp(ch, TYPECODE(Password));
        fn             := "~/.pa_new_display";
      BEGIN
        IF pw = NIL THEN
          LOCK iMu DO
            IF NOT pInited THEN
              pInited := TRUE;
              EVAL Env.Get("PA_NEW_DISPLAY", fn);
              TRY
                fn := Filename.ExpandTilde(fn);
                VAR rd := FileStream.OpenRead(fn); BEGIN
                  DefaultPassword := Rd.GetLine(rd);
                  Rd.Close(rd)
                END
              EXCEPT
                Filename.Error, Rd.Failure, Rd.EndOfFile, Thread.Alerted  =>
              END
            END;
            pw := NEW(Password, pass := DefaultPassword)
          END;
          VBT.PutProp(ch, pw)
        END;
        IF trsl # NIL AND pw.pass = NIL
             OR m.oldAuth # NIL AND Text.Equal(m.oldAuth, pw.pass) THEN
          VAR
            instance, windowTitle, iconTitle, applName: TEXT;
            bgColorR, bgColorG, bgColorB              : REAL;
            iconWindow                                : VBT.T;
            decorated := Trestle.GetDecoration(
                           ch, instance, windowTitle, iconTitle, applName,
                           bgColorR, bgColorG, bgColorB, iconWindow);
          BEGIN
            pw.pass := m.newAuth;
            IF pw.pass # NIL AND Text.Equal(pw.pass, "") THEN
              pw.pass := NIL
            END;
            v.expectedDelete := TRUE;
            Trestle.Delete(ch);
            TRY
              IF d # NIL THEN TrestleGoo.PutProp(ch, d) END;
              Trestle.Attach(ch, trsl);
              IF decorated THEN
                Trestle.Decorate(
                  ch, instance, windowTitle, iconTitle, bgColorR, bgColorG,
                  bgColorB, applName, iconWindow)
              END;
              IF m.iconic THEN
                Trestle.Iconize(ch)
              ELSE
                Trestle.Overlap(ch, m.screen, Point.T{m.x, m.y})
              END;
              m.status := TRUE
            EXCEPT
              TrestleComm.Failure => m.status := FALSE
            END
          END
        ELSE
          m.status := FALSE
        END
      END
    ELSIF (cd.type = VBT.Deleted OR cd.type = VBT.Disconnected)
            AND v.expectedDelete THEN
      VAR
        ch            := InstalledVBT.Child(v);
        pt: VBT.Split;
      BEGIN
        IF ch # NIL THEN
          pt := ch.parent;
          IF pt # NIL THEN Split.Delete(pt, ch) END
        END
      END
    ELSE
      Filter.T.misc(v, cd)
    END
  END Misc;

PROCEDURE Parent (v: VBT.T): T =
  BEGIN
    LOOP TYPECASE v OF T (p) => RETURN p ELSE v := v.parent END END
  END Parent;

PROCEDURE SetEnabled (ch: VBT.T; enabled := TRUE) =
  VAR v := Parent(ch);
  BEGIN
    IF v # NIL THEN v.enabled := enabled END
  END SetEnabled;

PROCEDURE GetEnabled (ch: VBT.T): BOOLEAN =
  VAR v := Parent(ch);
  BEGIN
    IF v # NIL THEN RETURN v.enabled ELSE RETURN TRUE END
  END GetEnabled;

BEGIN
END DpyFilter.


