(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 16:46:27 PDT 1992 by muller                   *)

INTERFACE RealExtra;

(* Some stuff that should be in Real.i3.

  (Of course, if you ask me, these items should all be built into the
  language.) 
  
  Note: the parameters of most procedures below are declared READONLY to 
  avoid C's automatic conversion to and from LONGREAL when passing through
  procedure boundaries. 

  On IEEE machines, the procedures below will treat zero and minus
  zero as entirely equivalent.  They will also never return NaNs or infinities, 
  and will fail with an error if applied to NaNs or infinities. 

  *)

VAR (*CONST*)
  First: REAL;    (* Smallest finite REAL *)
  Last: REAL;     (* Largest finte REAL *)
  MinPos: REAL;   (* Smallest positive REAL *)
  MinNorm: REAL;  (* Smallest positive normalized REAL *)

EXCEPTION Overflow;  (* Range fault in floating-point operations *)

PROCEDURE SUCC(READONLY x: REAL): REAL RAISES {Overflow};
  (*
    Smallest finite REAL greater than x.  SUCC(Last) raises Overflow. *)

PROCEDURE PRED(READONLY x: REAL): REAL RAISES {Overflow};
  (*
    Largest finite REAL smaller than x. PRED(First) raises Overflow. *)

PROCEDURE SIGN(READONLY x: REAL): [-1..+1];
  (*
    The sign of x. *)

PROCEDURE FRACTION(READONLY x: REAL): REAL RAISES {};
  (*
    If x is zero, returns zero. If x is not zero, returns x scaled 
    by an integral power of 2 such that the result is between 0.5 
    (inclusive) and 1.0 (exclusive) in absolute value. *)
    
PROCEDURE EXPONENT(READONLY x: REAL): INTEGER RAISES {};
  (*
    If x is 0.0, returns 0. If x is not 0, returns the integer /e/ such that 
    x * 2^e is between 0.5 (inclusive) and 1.0 (exclusive). *)

PROCEDURE NORMALIZE(VAR x: REAL; VAR (*OUT*) e: INTEGER) RAISES {};
  (*
    Sets e := EXPONENT(x), x := FRACTION(x). *)
    
PROCEDURE SCALE(VAR x: REAL; exp: INTEGER) RAISES {};
  (*
    Sets x := x * 2^exp. If x is too small or exp is too negative,
    may drop the least significant bits, or return zero.
    If the result does not fit in the finite number range, sets /x/ 
    to First or Last, preserving its original sign. *)

END RealExtra.

