(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Sep  9 23:10:22 PDT 1992 by mhb                      *)
(*      modified on Tue Jun 16 23:42:53 PDT 1992 by muller                   *)

MODULE gallery EXPORTS Main;

IMPORT Axis, BorderedVBT, Cursor, CursorFromAscii, FileStream,
       HVSplit, List, M3Config, PackSplit, PaintOp, ParseParams, Pixmap,
       PixmapFromAscii, PixmapVBT, Rd, Scan, Split, Text, TextList,
       TextVBT, Thread, Trestle, TrestleComm, VBT, UnixUtils;

<* FATAL Thread.Alerted, TrestleComm.Failure *>

CONST
  CURSORDIR = "gallery-cursors";
  PIXMAPDIR = "gallery-pixmaps";

PROCEDURE AddChild (image: VBT.T; name: Text.T) =
  BEGIN
    IF image = NIL THEN image := TextVBT.New("unreadable") END;
    Split.AddChild(
      pack, HVSplit.Cons(Axis.T.Ver, image, TextVBT.New(name)))
  END AddChild;

PROCEDURE GetPixmap (rd: Rd.T): VBT.T
  RAISES {PixmapFromAscii.Error} =
  BEGIN
    RETURN PixmapVBT.New(PixmapFromAscii.Read(rd))
  END GetPixmap;

PROCEDURE GetCursor (rd: Rd.T): VBT.T
  RAISES {CursorFromAscii.Error} =
  VAR
    raw := CursorFromAscii.ReadRaw(rd);
    image := BorderedVBT.New(
               HVSplit.Cons(
                 Axis.T.Hor,
                 PixmapVBT.New(Pixmap.FromBitmap(raw.plane1)),
                 PixmapVBT.New(Pixmap.FromBitmap(raw.plane2))));
  BEGIN
    VBT.SetCursor(image, Cursor.FromRaw(raw));
    RETURN image;
  END GetCursor;

PROCEDURE Get (file: Text.T): VBT.T =
  <* FATAL UnixUtils.Error *>
  VAR rd: Rd.T;
  BEGIN
    IF NOT UnixUtils.ProbeFile(file, FALSE)
         OR UnixUtils.IsDirectory(file) THEN
      RETURN NIL
    END;
    TRY
      TRY
        rd := FileStream.OpenRead(file);
        TRY RETURN GetCursor(rd) FINALLY Rd.Close(rd) END
      EXCEPT
        CursorFromAscii.Error =>
      END;
      TRY
        rd := FileStream.OpenRead(file);
        TRY RETURN GetPixmap(rd) FINALLY Rd.Close(rd) END
      EXCEPT
        PixmapFromAscii.Error =>
      END;
    EXCEPT
      Rd.Failure =>
    END;
    RETURN NIL
  END Get;

PROCEDURE ScanDir (dir: Text.T): TextList.T =
  BEGIN
    IF UnixUtils.IsDirectory(dir) THEN
      TRY RETURN UnixUtils.Directory(dir) EXCEPT UnixUtils.Error => END;
    END;
    RETURN NIL
  END ScanDir;


VAR 
  pack := PackSplit.New(
            Axis.T.Hor, 1.5, 1.5, Pixmap.Gray, PaintOp.BgFg);

<* FATAL Scan.BadFormat *>
BEGIN

  ParseParams.BeginParsing();

  IF ParseParams.NextParameter = ParseParams.NumParameters THEN
    VAR
      lib := NARROW(List.First(M3Config.Lib()), TEXT);
      dirs := TextList.List2(lib & "/" & PIXMAPDIR, lib & "/" & CURSORDIR);
      files : TextList.T;
    BEGIN
      WHILE dirs # NIL DO
        files := ScanDir(dirs.first);
        WHILE files # NIL DO
          AddChild(Get(dirs.first & "/" & files.first), files.first);
          files := files.tail
        END;
        dirs := dirs.tail
      END
    END
  ELSE
    WHILE ParseParams.NextParameter < ParseParams.NumParameters DO
      WITH parm = ParseParams.GetNext() DO
        AddChild(Get(parm), parm)
      END;
    END;
  END;

  ParseParams.EndParsing();
  Trestle.Install(pack);
  Trestle.AwaitDelete(pack);

END gallery.

