(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Aug  5 21:38:20 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:09:04 PDT 1992 by muller     *)
(*      modified on Mon Jun 15 18:48:12 1992 by mhb        *)


MODULE BiFeedbackVBT;

IMPORT Feedback, FeedbackClass, Filter, Multi, MultiClass, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init := Init;
      END;
  
  FC = FeedbackClass.T BRANDED OBJECT
       OVERRIDES
         normal  := Normal;
         excited := Excited;
       END;

  MC = MultiClass.T BRANDED OBJECT
       OVERRIDES
         pred     := Succ;
         succ     := Succ;
         replace  := Replace;
       END;

PROCEDURE Init (v            : T;
                ch           : Feedback.T;
                multiclass   : MC           := NIL;
                feedbackclass: FC           := NIL  ): T =
  VAR f1, f2: Feedback.T;
  BEGIN
    EVAL Filter.T.init (v, ch);
    IF feedbackclass = NIL THEN feedbackclass := NEW (FC) END;
    FeedbackClass.Be (v, feedbackclass);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    f1 := ch;
    f2 := Multi.Child (f1);
    MultiClass.BeChild (v, Multi.Child (f2));
    Feedback.Normal (v);
    RETURN v
  END Init;

PROCEDURE Normal (fc: FC) =
  VAR
    v : T          := fc.vbt;
    f1: Feedback.T := Filter.Child (v);
    f2: Feedback.T := Multi.Child (f1);
  BEGIN
    Feedback.SetState (f1, Feedback.GetState (v));
    Feedback.Normal (f1);
    Feedback.SetState (f2, Feedback.GetState (v));
    Feedback.Normal (f2)
  END Normal;

PROCEDURE Excited (fc: FeedbackClass.T) =
  VAR
    v : T          := fc.vbt;
    f1: Feedback.T := Filter.Child (v);
    f2: Feedback.T := Multi.Child (f1);
  BEGIN
    Feedback.SetState (f1, Feedback.GetState (v));
    Feedback.Excited (f1);
    Feedback.SetState (f2, Feedback.GetState (v));
    Feedback.Excited (f2)
  END Excited;
  
PROCEDURE Replace (m: MC; ch, new: VBT.T)
  RAISES {Multi.NotAChild} =
  VAR
    v : T          := m.vbt;
    f1: Feedback.T := Filter.Child (v);
    f2: Feedback.T := Multi.Child (f1);
  BEGIN
    Multi.Replace (f2, ch, new);
  END Replace;

PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T
  RAISES {Multi.NotAChild} =
  VAR
    v : T          := m.vbt;
    f1: Feedback.T := Filter.Child (v);
    f2: Feedback.T := Multi.Child (f1);
  BEGIN
    IF ch = NIL THEN
      RETURN Multi.Succ (f2, ch)
    ELSE
      RETURN NIL
    END
  END Succ;

BEGIN
END BiFeedbackVBT.
