(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug 10  0:22:50 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:09:00 PDT 1992 by muller *)
(*      modified on Mon Jun 15 20:48:15 1992 by mhb    *)
(*      modified on Thu Apr 2 21:31:51 1992 by steveg *)


(* A "ChoiceVBT" multi-filter behaves in concert with other
   "ChoiceVBT"s to implement {\em radio buttons}.  At any given
   time, all of the related "ChoiceVBT"s have a "FALSE" state,
   except, at most, one.  This one is called the {\em selection}.
   If no choices are in the "TRUE" state, the selection is "NIL".

   Structurally, a "ChoiceVBT" is identical to a "BooleanVBT";
   refer to that interface for details. *)

INTERFACE ChoiceVBT;

IMPORT BooleanVBT, ButtonVBT, Filter, Radio, VBT;

TYPE
  T <: Public;
  Public = Filter.T OBJECT
           METHODS
             callback (READONLY cd: VBT.MouseRec);
             init (switch    : ButtonVBT.T;
                   group     : Radio.T;
                   multiclass: MC            := NIL): T
           END;

(* The call "v.init(...)" initializes "v" as a "ChoiceVBT" with
   an initial state of "FALSE" and in the a radio group
   "group". *)

TYPE MC = BooleanVBT.MC;
(* The type "MC" overrides the "replace", "pred", and "succ"
   methods of "BooleanVBT.MC". *)


PROCEDURE Put (v: T);
(* Let "g" be "v"'s radio group.  Set the state of "g"'s current
   selection to "FALSE"; make "v" the current selection thereby
   setting its state to "TRUE". *)

PROCEDURE Clear (v: T);
(* Let "g" be "v"'s radio group.  Set the state of "g"'s current
   selection to "FALSE"; make "NIL" the current selection. *)

PROCEDURE Get (v: T): T;
(* Return the current selection in "v"'s radio group.  Note that
   this may be "NIL". *)

PROCEDURE GetGroup (v: T): Radio.T;
(* Return the radio group containing "v". *)

 END ChoiceVBT.

