(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 30 21:28:08 PDT 1992 by meehan                   *)
<* PRAGMA LL *>

INTERFACE ClipboardVBT;

IMPORT Filter, VBT;

TYPE
  T <: Filter.T OBJECT
       METHODS
         <* LL.sup <= VBT.mu *>
         get (time: VBT.TimeStamp): TEXT;
         put (val: TEXT; time: VBT.TimeStamp)
       END;

(* A "ClipboardVBT" is a filter that stores a text and associates
   it with "VBT.Source".  The initial value of the text is the
   empty string.

   The call "v.put(text, time)" will cause "v" to acquire
   "VBT.Source" and also store "text".  The call "v.get(time)"
   will cause "v" to acquire "VBT.Source" and also return the
   text.

   Since "VBT.Source" is a global resource, subsequent calls
   (from any Trestle client) to "VBT.Read" with "selection =
   VBT.Source" will retrieve the text, and subsequent calls to
   "VBT.Write" with "selection = VBT.Source" will store the text.
*)

PROCEDURE Find(v: VBT.T): T; <* LL.sup = VBT.mu *>
(* Return the lowest (possibly improper) ancestor of "v" that is a
   "ClipboardVBT.T" or "NIL" if there isn't one. *)

END ClipboardVBT.
