(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sun Aug  9 19:57:16 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:59 PDT 1992 by muller *)
(*      modified on Mon Jun 15 20:25:05 1992 by mhb *)

(* A "DragSwitchVBT" is a switch version of Trestle's
   "DragBtnVBT".

   Actually, "DragBtnVBT" does not exist.  If it existed, it
   would be a "ButtonVBT" subclass that generates events while a
   mouse button is down and has moved since the last time an
   event was generated.  Events are generated even when the mouse
   is outside the "VBT"'s domain, as long as it remains on the
   screen.

   The "pre" method is invoked on the first click in the "VBT"; the
   "post" method is called on an uncanceled upclick; the "cancel"
   method is called whenever the mouse is ``chorded''; the "during"
   method is called whenever the mouse has moved since the last call
   to "during" or "pre".  A new cage containing the current
   cursor position will be set before calls to "pre" and
   "during".  The "callback" method is invoked on an uncancelled
   upclick.  The default "during" and "callback" methods are
   no-ops. *)

INTERFACE DragSwitchVBT;

IMPORT ButtonVBT, Feedback, SwitchVBT, VBT;

TYPE
  T <: Public;
  Public = ButtonVBT.T OBJECT
           METHODS
             init     (f: Feedback.T; multiclass: MC := NIL): T;
             during   (READONLY cd: VBT.PositionRec);
             callback (READONLY cd: VBT.MouseRec);
           END;

  MC = SwitchVBT.MC;
  
END DragSwitchVBT.





