(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug  3 15:33:27 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:22 PDT 1992 by muller *)
(*      modified on Mon Jun 15 21:49:38 1992 by mhb    *)
(*      modified on Thu May 28 01:34:55 1992 by steveg *)
<* PRAGMA LL *>

(* A "ScaleFilter" is a filter whose child's screentype is the
   same as the parent's except that the resolution is scaled. *)

INTERFACE ScaleFilter;

IMPORT VBT;

TYPE
  T <: Public;
  Public = Private OBJECT METHODS init (ch: VBT.T): T END;
  Private <: VBT.T;

(* The call "v.init(ch)" initializes "v" as a "ScaleFilter" with
   child "ch" and whose horizontal and vertical scale factors are
   1.0.

   A "ScaleFilter" is {\em not\/} defined as subclass of
   "Filter.T" because "Filter.Replace" requires both parent and
   the new child to have the same screentype.  Indeed, breaking
   this invariant is the purpose of a "ScaleFilter".  This is
   not a serious limitation: you can initialize a "ScaleFilter"
   with "NEW(Filter.T)", and change the grandchild of the
   "ScaleFilter."  *)

PROCEDURE New (ch: VBT.T): T;
<* LL.sup = VBT.mu *>
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

PROCEDURE Scale (t: T; hscale, vscale: REAL);
<* LL.sup = VBT.mu.t *>
(* Set "t"'s horizontal and vertical scale factors to "hscale"
   and "vscale" respectively. *)

PROCEDURE Child(t: T): VBT.T;
(* Returns "t"'s child *)

PROCEDURE Get(t: T; VAR (* OUT *) hscale, vscale: REAL);
(* Return "t"'s horizontal and vertical scale factors. *)

END ScaleFilter.
