(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 23:12:53 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:15 PDT 1992 by muller *)
(*      modified on Sat Jun 13 08:45:41 1992 by mhb    *)
<* PRAGMA LL *>

(* A "ShadowedVBT.T" is a filter whose parent's screen consists
   of the child's screen surrounded by a shadow.  The colors and
   size of the shadow can be set dynamically, as can the style of
   the shadow.  The parent's shape is determined from the child's
   shape by adding the shadow size. *)

INTERFACE ShadowedVBT;

IMPORT Filter, Shadow, VBT;

TYPE
  T <: Public;
  Public = Filter.T OBJECT
           METHODS
             <* LL.sup <= VBT.mu *>
             init (ch    : VBT.T;
                   shadow: Shadow.T := NIL;
                   style            := Shadow.Style.Flat): T;
           END;

(* The call "v.init(...)" initializes "v" as a "ShadowedVBT" with
   child "ch" and the given "shadow" and "style".  Each dimension
   of "v" exceeds the corresponding dimension of "ch" by "2 *
   ABS(shadow.size)".  If "shadow=NIL", it defaults to
   "Shadow.None". *)

PROCEDURE New (ch    : VBT.T;
               shadow: Shadow.T := NIL;
               style            := Shadow.Style.Flat): T;
<* LL.sup <= VBT.mu *>
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

PROCEDURE Set (v: T; shadow: Shadow.T);
<* LL.sup = VBT.mu *>
(* Change the size and colors of "v"'s shadow and mark "v" for
   redisplay.  If the size has in fact changed, notify "v"'s
   parent that "v"'s shape has changed. *)

PROCEDURE SetStyle (v: T; style: Shadow.Style);
<* LL.sup = VBT.mu *>
(* Change the "style" of "v"'s shadow and mark "v" for
   redisplay. *)

PROCEDURE Get (v: T): Shadow.T;
<* LL.sup = VBT.mu *>
(* Return "v"'s shadow. *)

PROCEDURE GetStyle (v: T): Shadow.Style;
<* LL.sup = VBT.mu *>
(* Return "v"'s shadow style.  *)

END ShadowedVBT.









