(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Sep 22 12:40:47 PDT 1992 by mhb        *)
(*      modified on Sun Aug  9 19:51:36 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:11 PDT 1992 by muller     *)
(*      modified on Fri Jul 26 15:36:28 PDT 1991 by steveg     *)

MODULE SwitchVBT;

IMPORT ButtonVBT, Feedback, Filter, Multi, MultiClass, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init     := Init;
      END;
  MC = MultiClass.T BRANDED OBJECT
       OVERRIDES
         succ    := Succ;
         pred    := Succ;
         replace := Replace;
       END;

PROCEDURE Init (v: T; f: Feedback.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL ButtonVBT.T.init (v, f, Action);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild (v, Multi.Child (f));
    RETURN v
  END Init;

PROCEDURE Action (         selfAsButtonVBT: ButtonVBT.T;
                  READONLY cd             : VBT.MouseRec ) =
  BEGIN
    NARROW (selfAsButtonVBT, T).callback (cd)
  END Action;

PROCEDURE DefaultCallback ( <* UNUSED *> v: ButtonVBT.T;  
                            <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END DefaultCallback;

PROCEDURE Pre (v: ButtonVBT.T) =
  BEGIN
    Feedback.Excited (Filter.Child (v));
  END Pre;

PROCEDURE Post (v: ButtonVBT.T) =
  BEGIN
    Feedback.Normal (Filter.Child (v));
  END Post;

PROCEDURE Cancel (v: ButtonVBT.T) =
  BEGIN
    Feedback.Normal (Filter.Child(v));
  END Cancel;

PROCEDURE Replace (m: MC; ch: VBT.T; new: VBT.T) =
  BEGIN
    WITH switch = m.vbt,
         feedback = Filter.Child (switch) DO
      <* ASSERT feedback = ch *>
      EVAL Multi.ReplaceChild (feedback, new);
    END
  END Replace;

PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    WITH switch = m.vbt,
         feedback = Filter.Child (switch) DO
      IF ch = NIL THEN
        RETURN Multi.Child (feedback);
      ELSE
        <* ASSERT feedback = ch *>
        RETURN NIL
      END;
    END
  END Succ;

BEGIN
END SwitchVBT.
