(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Wed Oct 28 14:01:48 PST 1992 by steveg *)
(*      modified on Fri Sep 11 21:58:03 PDT 1992 by mhb *)

MODULE VBTKitResources;

IMPORT Cursor, CursorFromAscii, Image, Pixmap, PixmapFromAscii, Rd, Rsrc,
       Thread, VBTKitBundle;

VAR path := Rsrc.BuildPath("$VBTKITPATH", VBTKitBundle.Get());

PROCEDURE Get (name: TEXT): TEXT =
  <* FATAL Rsrc.NotFound, Thread.Alerted, Rd.Failure *>
  BEGIN
    WITH t = Rsrc.Get(name, path) DO
      IF t = NIL THEN <* ASSERT FALSE *> END;
      RETURN t
    END
  END Get;

PROCEDURE GetCursor (name: TEXT): Cursor.T =
  <* FATAL Rsrc.NotFound, Thread.Alerted, CursorFromAscii.Error, Rd.Failure *>
  VAR rd := Rsrc.Open(name, path);
  BEGIN
    TRY RETURN CursorFromAscii.Read(rd) FINALLY Rd.Close(rd) END;
  END GetCursor;

PROCEDURE GetPixmap (name: TEXT): Pixmap.T =
  <* FATAL Rsrc.NotFound, Thread.Alerted, PixmapFromAscii.Error, Rd.Failure *>
  VAR rd := Rsrc.Open(name, path);
  BEGIN
    TRY
      WITH image = NEW(Image.Raw, bits := PixmapFromAscii.ReadRaw(rd),
                       colors := Image.BitmapColors) DO
        RETURN Image.Scaled(ARRAY OF Image.Raw{image})
      END
    FINALLY
      Rd.Close(rd)
    END;
  END GetPixmap;

BEGIN
END VBTKitResources.

