(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31  0:34:14 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:07:54 PDT 1992 by muller *)
(*      modified on Fri Dec 13 21:57:56 PST 1991 by mhb *)

MODULE ZTilps;

IMPORT Multi, MultiClass, Rect, Split, VBT, ZChildVBT, ZSplit;

<* FATAL Split.NotAChild, Multi.NotAChild *>

REVEAL
  T = Public BRANDED OBJECT
           OVERRIDES
             init := Init;
           END;

REVEAL
  MC = MultiClass.T BRANDED OBJECT
       OVERRIDES
         insert  := Insert;
         replace := Replace;
         succ    := Succ;
         pred    := Pred;
       END;

PROCEDURE Init (v         : T;
                saveBits        := FALSE;
                parlim          := -1;
                multiclass: MC  := NIL    ): T =
  BEGIN
    EVAL ZSplit.T.init (v, NIL, saveBits, parlim);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    RETURN v
  END Init;

PROCEDURE Insert (m: MC; pred, ch: VBT.T)
  RAISES {Multi.NotAChild} =
  VAR
    derp: VBT.T;
    v   : T     := m.vbt;
  BEGIN
    IF pred # NIL AND NOT MultiClass.IsChild (v, pred) THEN
      RAISE Multi.NotAChild;
    END;
    MultiClass.BeChild (v, ch);
    derp := Split.Pred (v, pred);
    ZSplit.InsertAfter (
      v, derp, ch, Rect.Empty, ZChildVBT.InitiallyMapped (ch));
    ZChildVBT.Inserted (ch)
  END Insert;

PROCEDURE Replace (m: MC; ch, new: VBT.T)
  RAISES {Multi.NotAChild} =
  BEGIN
    Split.Replace (m.vbt, ch, new)
  END Replace;

PROCEDURE Succ (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    RETURN Split.Pred (m.vbt, ch)
  END Succ;

PROCEDURE Pred (m: MC; ch: VBT.T): VBT.T =
  BEGIN
    RETURN Split.Succ (m.vbt, ch)
  END Pred;

BEGIN
END ZTilps.



