(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sun Jul  5 19:57:40 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:16:24 PDT 1992 by muller *)
(*      modified on Fri Oct  7 14:32:06 1988 by chan *)
(*      modified on Mon Jul  6 09:56:11 1987 by brooks *)

INTERFACE MTextPrivate;

IMPORT MText, Rd;

REVEAL MText.T = BRANDED "MText.T" REF NodeRec;
        (* the concrete type, defined below *)

VAR debug: BOOLEAN := FALSE;

TYPE
  Node = MText.T;

  NodeType = {tree, text, file, buf, anchor, top};
  (* To Modula, types Node and T are equal. However, we use T to refer only
     to a top node, for the purpose of representing the whole MText. Node
     refers to any sort of node. Only T is exported, and it is opaque. *)

  NodeRec =
    RECORD
      up    : Node      := NIL; (* parent *)
      id    : INTEGER;          (* FOR DEBUGGING *)
      length: CARDINAL  := 0;   (* number of characters in this subtree *)

      (* ! CASE !*)
      type: NodeType;
      (* ! OF !*)

      (* ! NodeType.tree: !*)(* an interior node *)
      left, right: Node;        (* the two children *)

      leftSize: CARDINAL;       (* number of chars in left subtree *)

      sub: BOOLEAN;
      (* TRUE if this is a right subnode of a node in the 2-3 tree we are
         modeling. *)

      (* ! NodeType.text: !*)(* a leaf containing a Text *)
      text: TEXT := "";         (* the text *)

      (* ! NodeType.buf: !*)(* a leaf containing a typein buffer *)
      buffer: REF ARRAY OF CHAR;  (* a mutable buffer *)

      (* ! NodeType.file: !*)(* a leaf referring to part of a file *)
      file : Rd.T;
      start: CARDINAL;          (* where this piece starts in the file *)

      (* ! NodeType.top: !*)(* the header node, one per MText *)
      (* No fields for 'top' node *)

      lock: MUTEX;              (* for reading and updating the mtext *)

      root: Node;               (* root of the tree *)

      height: CARDINAL;         (* height of the tree, 1 leaf => 0 *)

      bufNode: Node;            (* handy access to the mutable buffer *)

      bufMax: CARDINAL;         (* maximum size of mutable buffer *)

      version: CARDINAL := 0;   (* is incremented each modification. *)

      (* ! NodeType.anchor: ! *)(* no contents *)

    END;

PROCEDURE Check (VAR start, end: CARDINAL; actualLength: CARDINAL);
   
END MTextPrivate.
