(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Aug  4 12:51:46 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 12:55:53 PDT 1992 by muller                   *)
(*      modified on Wed Jun  3 10:40:01 1992 by mhb    *)
(*      modified on Tue Jan 29 14:08:55 PST 1991 by brooks *)
(*      modified on Tue Dec 4 6:34:15 PST 1990 by steveg *)

(* The "MiscCodes" interface is the place to allocate "VBT"
   miscellaneous codes for widespread use.  Feel free to add to
   this interface, {\em provided} that the codes thus allocated
   are genuinely of public interest, not just for one
   application. *)

INTERFACE MiscCodes;

IMPORT VBT;

CONST Detail = VBT.MiscCodeDetail{12345, 67890};
(* Use this when sending a miscellanous code whose type is
   defined here.  When a VBT responds to a miscellaneous event
   whose "MiscCodeType" is in the range of this interface, it can
   check the "MiscCodeDetail" to be sure that the sender is using
   the type from this interface. *)

VAR SwapHighlights: VBT.MiscCodeType;
(* Used by text applications when swapping source and target
   selections (the highlights, not the text thereof).  The owner
   of target sends it to owner of source, who can use it as a
   signal to grab target.  Sender will presumably grab source
   soon after. *)

END MiscCodes.






