(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug  3 18:00:30 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 12:56:23 PDT 1992 by muller                   *)
(*      modified on Wed Jun  3 10:18:43 1992 by mhb *)

(* The "PaintOpCache" interface provides a cache of "PaintOp"
   objects.  For efficiency, use this interface for creating
   "PaintOp" objects rather than the "PaintOp" interface
   itself.

   Although a "PaintOp.T" is a cheap data structure, it does have
   some cost: Each "PaintOp.T" data structure is a "REF" to a
   structure with 6 words (at least).  When rescreening a "VBT", a
   method on each "PaintOp.T" is invoked.  Since "VBT"-based
   interactive graphical applications typically use hundreds, if
   not thousands, of "VBT"s, a few "PaintOp.T"s per "VBT" can begin
   to add up.  Both "PaintOp.ColorQuad" and "PaintOp.ColorScheme"
   are data structures that contains lots of "PaintOp.T"s.
   Caching at this level is even more effective.

   The procedures here correspond to those in the "PaintOp"
   interface.  If an entry was previously called with the same
   arguments, the previous value is returned; otherwise, the
   corresponding entry in the "PaintOp" interface is invoked, and
   the value is cached for future reference and then returned.
   All calls are internally serialized. *)

INTERFACE PaintOpCache;

IMPORT PaintOp, RGB;

PROCEDURE FromRGB (rgb : RGB.T;
                   mode          := PaintOp.Mode.Normal;
                   gray          := -1.0;
                   bw            := PaintOp.BW.UseIntensity):
  PaintOp.T;
(* Note: "PaintOp.FromRGB" takes three numbers rather than a
   "RGB.T". *)

PROCEDURE MakeColorQuad (bg, fg: PaintOp.T): PaintOp.ColorQuad;

PROCEDURE MakeColorScheme (bg, fg: PaintOp.T):
  PaintOp.ColorScheme;

END PaintOpCache.





