(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* Last modified on Thu Sep 10 10:18:07 PDT 1992 by mhb *)

(* This interface converts an ascii representation of a VBTkit or
   X bitmap into a "Pixmap.T".  The VBTkit representation is
   undocumented; the X representation is that used by the
   "bitmap(1)" program. *)

INTERFACE PixmapFromAscii;

IMPORT Pixmap, Rd, Thread;

EXCEPTION Error;

PROCEDURE Read (rd: Rd.T): Pixmap.T
  RAISES {Thread.Alerted, Error};
(* =Pixmap.FromBitmap(ReadRaw(rd)) *)

PROCEDURE ReadRaw (rd: Rd.T): Pixmap.Raw
  RAISES {Thread.Alerted, Error};
(* Return a Pixmap.Raw version of the pixmap's ascii description
   stored in the reader.  The format of the ascii description is
   guessed from the first character of the file.  If it's a sharp
   sign, the file is assumed to have been created by X's bitmap
   program.  Otherwise, it's assumed to be in a VBTkit-specific
   format.  Raises Error if the ascii pixmap description contains
   any sort of error. *)

END PixmapFromAscii.

