(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Aug  4 11:40:50 PDT 1992 by meehan                   *)
(*      modified on Tue Jun 16 12:57:47 PDT 1992 by muller                   *)
(*      modified on Thu Jun 11 23:10:28 1992 by mhb                          *)

(* The "VBTColors" interface provides a way to associate a "VBT"'s
   background and foreground colors with the "VBT".  This
   information can be retrieved by some other "VBT" to compute a
   related (or complementary) color.

   For example, "ZDragVBT" and "ZMoveVBT" traverse up the "VBT"
   "ZSplit"'s background child.  It uses the colors' "transparentSwap"
   tree to find a "ZSplit", and then finds the colors of a
   painting operation that ensures that a rectangular outline can be
   seen while being dragged. *)

INTERFACE VBTColors;

IMPORT PaintOp, VBT;

PROCEDURE Put (v: VBT.T; colors: PaintOp.ColorScheme);
(* Store "colors" with "v". *)

PROCEDURE Get (v: VBT.T): PaintOp.ColorScheme;
(* Returns the colors stored by the most recent call to "Put".
   If "Put" has never been called on "v", returns "PaintOp.bgFg".
   Calls to "Get" and "Put" are internally serialized. *)

END VBTColors.

