(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified On Tue Jun 16 13:12:38 PDT 1992 by muller *)
(*      modified On Fri Mar 20 10:50:07 PST 1992 by jdd *)
(* modified On Sun Nov 24 19:01:30 PST 1991 by meehan *)
(* Modified On Tue May 15 17:04:57 PDT 1990 by mcjones *)

MODULE VTRd;

IMPORT MText, MTextRd, Range, Rd, Thread;

PROCEDURE InitReaderIx (vt: T; index: I)
  RAISES {Rd.Failure, Thread.Alerted} =
  <*FATAL Range.Error*>
  BEGIN
    IF vt.rdDirty THEN
      IF vt.rd # NIL THEN Rd.Close(vt.rd) END;
      vt.rd := MTextRd.New(vt.mtext, index);
      vt.rdDirty := FALSE;
    ELSE
      Rd.Seek(vt.rd, index);
    END;
  END InitReaderIx;

PROCEDURE Rev (vt: T) RAISES {Rd.Failure, Thread.Alerted} =
  <*FATAL Range.Error*>
  BEGIN
    IF vt.rrd # NIL THEN Rd.Close(vt.rrd) END;
    vt.rrd := MTextRd.New(vt.mtext, Rd.Index(vt.rd), 0, LAST(MText.Index),
                          reverse := TRUE);
  END Rev;

BEGIN
END VTRd.

