(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Target.i3.Mosaic                                      *)
(* Last Modified On Thu Sep 10 12:30:07 PDT 1992 By rustan     *)

INTERFACE Target  (* for Mosaic C *);

(* This interface describes the target architecture *)

CONST
  (* integers *)
  INTSIZE  =     16;
  INTALIGN =     16;
  MAXINT   =  32767;
  MININT   = -32768;

  (* shorts *)
  SHORTSIZE  =     16;
  SHORTALIGN =     16;
  MAXSHORT   =  32767;
  MINSHORT   = -32768;
  MAXUSHORT  =  65535;
  MINUSHORT  =      0;

  (* characters *)
  CHARSIZE  =     16;
  CHARALIGN =     16;
  MAXCHAR   =  32767;
  MINCHAR   = -32768;
  MAXSCHAR  =  32767;
  MINSCHAR  = -32768;
  MAXUCHAR  =  65535;
  MINUCHAR  =      0;

  (* booleans *)
  BOOLSIZE  = 16;
  BOOLALIGN = 16;

  (* reals *)
  REALSIZE  = 32;
  REALALIGN = 32;
  MAXREAL    =  "3.40282346638528860e+38";
  MINREAL    = "-3.40282346638528860e+38";
  (* MINPOSREAL =  1.40129846432481707e-45; *)

  (* longreals *)
  LONGREALSIZE  = REALSIZE;
  LONGREALALIGN = REALALIGN;
  MAXLONGREAL   =  MAXREAL;
  MINLONGREAL   = MINREAL;
  (* MINPOSLONGREAL = MINPOSREAL; *)

  (* extended reals *)
  EXTENDEDSIZE  = LONGREALSIZE;
  EXTENDEDALIGN = LONGREALALIGN;
  MAXEXTENDED   = MAXLONGREAL;
  MINEXTENDED   = MINLONGREAL;

  (* addresses *)
  ADDRSIZE  = 16;
  ADDRALIGN = 16;
  ADDRUNIT  = 16;

  (* C structures *)
  PCCBITFIELDTYPEMATTERS = TRUE;   (* use the type rather than the size of
                                      a bit-field to compute alignment *)
  STRUCTURESIZEBOUNDARY = 16;  (* every structure size must be a multiple 
                                  of this *)
  BITFIELDCANOVERLAP = FALSE;  (* a bit field cannot overlap two adjacent 
                                  storage units *)  

  (* NIL checking *)
  FIRSTREADABLEADDR = 0;
  (* Read or write references to addresses in the range [0..FIRSTREADABLE-1]
     will cause an address faults.  Hence, no explicit NIL checks are needed
     for dereferencing with offsets in this range. *)

  (* Thread stacks *)
  (* BUG.  The following numbers need to be checked. *)
  JumpBufSize    = 8 * ADDRSIZE;    (* size of a "jmp_buf" *)
  FixedFrameSize = 1 * ADDRSIZE;    (* size of an "empty" stack frame *)
  GuardPageSize  = 0;               (* size of the "unmapped" region at the
                                       end of a thread stack *)
  (* These parameters are used to estimate the size of each procedure's
     frame.  If the estimated size of a procedure's frame is less
     than the guard page's size, no explict check for stack overflow
     is needed.  *)

END Target.
