(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Abs.m3                                                *)
(* Last Modified On Mon Mar  2 10:23:02 PST 1992 By kalsow     *)
(*      Modified On Sat Dec  8 00:46:53 1990 By muller         *)

MODULE Abs;

IMPORT CallExpr, Expr, Type, Procedure, Emit, Error, Temp;
IMPORT Int, Reel, LReel, EReel, IntegerExpr, ReelExpr;

VAR Z: CallExpr.MethodList;

PROCEDURE TypeOf (<*UNUSED*> proc: Expr.T; VAR args: Expr.List): Type.T =
  BEGIN
    RETURN Type.Base (Expr.TypeOf (args[0]));
  END TypeOf;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  VAR t: Type.T;
  BEGIN
    t := Type.Base (Expr.TypeOf (args[0]));
    IF (t # Int.T) AND (t # Reel.T) AND (t # LReel.T) AND (t # EReel.T) THEN
      Error.Msg ("ABS: wrong argument type");
    END;
    RETURN t;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t: Type.T; e: Expr.T; t1, t2: Temp.T;
  BEGIN
    e := args[0];
    t := Type.Base (Expr.TypeOf (e));
    t1 := Expr.Compile (e);
    t2 := Temp.AllocEmpty (t);
    Emit.OpTT ("@ = @;\n", t2, t1);
    IF (t = Int.T)
      THEN Emit.OpTTT ("if (@ < 0) @ = - @;\n", t2, t2, t2);
      ELSE Emit.OpTTT ("if (@ < 0.0) @ = - @;\n", t2, t2, t2);
    END;
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e, x: Expr.T;  i: INTEGER;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF (e = NIL) THEN
      RETURN NIL;
    ELSIF IntegerExpr.Split (e, i) THEN
      IF (i < 0) THEN e := IntegerExpr.New (-i) END;
      RETURN e;
    ELSIF ReelExpr.Abs (e, x) THEN
      RETURN x;
    ELSE
      RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, NIL,
                                 TypeOf, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever(* designator *));
    Procedure.Define ("ABS", Z, TRUE);
  END Initialize;

BEGIN
END Abs.
