(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Adr.m3                                                *)
(* Last Modified On Mon Feb 10 15:24:09 PST 1992 By kalsow     *)
(*      Modified On Sat Dec  8 00:54:28 1990 By muller         *)

MODULE Adr;

IMPORT CallExpr, Expr, Type, Procedure, Error, Emit, Module, Addr, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    IF Module.IsSafe () THEN Error.Msg ("unsafe operation") END;
    IF  NOT Expr.IsDesignator (args[0]) THEN
      Error.Msg ("ADR: argument must be a designator");
    END;
    RETURN Addr.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.CompileLValue (args[0]);
    t2 := Temp.AllocEmpty (Addr.T);
    Emit.OpTT ("@ = (_ADDRESS)(& @);\n", t2, t1);
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Addr.T,
                                 NIL, Check, Compile, CallExpr.NoValue,
                                 CallExpr.IsNever,(* writable *)
                                 CallExpr.IsNever(* designator *));
    Procedure.Define ("ADR", Z, TRUE);
  END Initialize;

BEGIN
END Adr.
