(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: ByteSize.m3                                           *)
(* Last Modified On Thu Sep 17 15:10:05 PDT 1992 By rustan     *)
(*      Modified On Mon Feb 10 15:25:05 PST 1992 By kalsow     *)
(*      Modified On Tue Mar 20 03:05:35 1990 By muller         *)

MODULE ByteSize;

IMPORT CallExpr, Expr, Type, Procedure, BitSize, Card, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    BitSize.CheckArg ("BYTESIZE", args);
    RETURN Card.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  BEGIN
    RETURN BitSize.Gen (args[0], (*** KRML bug fix Target.CHARSIZE ***) 8 );
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  BEGIN
    RETURN BitSize.GetSize (args[0], (*** KRML bug fix Target.CHARSIZE ***) 8 );
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Card.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever(* designator *));
    Procedure.Define ("BYTESIZE", Z, TRUE);
  END Initialize;

BEGIN
END ByteSize.
