(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Trunc.m3                                              *)
(* Last Modified On Mon Mar  2 10:27:59 PST 1992 By kalsow     *)
(*      Modified On Tue Apr 10 10:57:52 1990 By muller         *)

MODULE Trunc;

IMPORT CallExpr, Expr, Type, Procedure, Ceiling, Int, Emit, ReelExpr, Temp;

VAR Z: CallExpr.MethodList;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  <*UNUSED*> VAR cs: Expr.CheckState): Type.T =
  BEGIN
    Ceiling.DoCheck ("TRUNC", args);
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Temp.AllocEmpty (Int.T);
    Emit.OpTT ("@ = _TRUNC (@);\n", t2, t1);
    Temp.Free (t1);
    RETURN t2;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR e, x: Expr.T;
  BEGIN
    e := Expr.ConstValue (args[0]);
    IF    (e = NIL)             THEN RETURN NIL
    ELSIF ReelExpr.Trunc (e, x) THEN RETURN x;
    ELSE (* bogus *)                 RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    Z := CallExpr.NewMethodList (1, 1, TRUE, FALSE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever(* designator *));
    Procedure.Define ("TRUNC", Z, TRUE);
  END Initialize;

BEGIN
END Trunc.
