(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: BuiltinArgs.i3                                        *)
(* Last Modified On Mon Mar  2 10:17:23 PST 1992 By kalsow     *)
(*      Modified On Thu May 17 08:58:04 1990 By muller         *)

INTERFACE BuiltinArgs;

IMPORT Value;

(* misc. predefined formals *)

VAR (*READONLY*)
  f1  : Value.T; (* VALUE "x" INTEGER,  #1 *)
  f2  : Value.T; (* VALUE "x" REAL,     #1 *)
  f3  : Value.T; (* VALUE "x" LONGREAL, #1 *)
  f4  : Value.T; (* VALUE "x" ADDRESS,  #1 *)

VAR
  f5  : Value.T; (* VALUE "y" INTEGER,  #2 *)
  f6  : Value.T; (* VALUE "y" REAL,     #2 *)
  f7  : Value.T; (* VALUE "y" LONGREAL, #2 *)
  f8  : Value.T; (* VALUE "y" ADDRESS,  #2 *)
  f9  : Value.T; (* VALUE "i" CARDINAL, #2 *)
  f13 : Value.T; (* VALUE "n" INTEGER,  #2 *)
  f14 : Value.T; (* VALUE "n" [0..Target.INTSIZE-1], #2 *)

VAR
  f10 : Value.T; (* VALUE "n" CARDINAL, #3 *)
  f11 : Value.T; (* VALUE "i" CARDINAL, #3 *)

VAR
  f12 : Value.T; (* VALUE "n" CARDINAL, #4 *)


PROCEDURE Initialize ();

END BuiltinArgs.
