(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: BuiltinTypes.m3                                       *)
(* Last Modified On Fri May 29 16:13:23 PDT 1992 By muller         *)
(*      Modified On Tue Jun 18 22:23:54 1991 By kalsow         *)

MODULE BuiltinTypes;

IMPORT Int, Card, Bool, Reel, LReel, EReel, CChar, Addr, Closure;
IMPORT Null, Reff, Textt, Mutex, Void, ObjectRef, ObjectAdr, Netwrk;
IMPORT BuiltinArgs;


PROCEDURE Initialize () =
  BEGIN
    (* builtin types *)
    (* NOTE: this list is ordered! *)
    Void.Initialize ();
    Int.Initialize ();
    Card.Initialize ();
    Bool.Initialize ();
    Reel.Initialize ();
    LReel.Initialize ();
    EReel.Initialize ();
    CChar.Initialize ();
    Null.Initialize ();
    Addr.Initialize ();
    Reff.Initialize ();
    ObjectRef.Initialize ();
    ObjectAdr.Initialize ();
    Textt.Initialize ();
    Mutex.Initialize ();
    Closure.Initialize ();
    Netwrk.Initialize ();
    BuiltinArgs.Initialize ();
  END Initialize;

BEGIN
END BuiltinTypes.
