(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: TypeRep.i3                                            *)
(* Last Modified On Tue Sep  1 16:39:07 PDT 1992 by rustan         *)
(*      Modified On Thu Feb 13 09:06:09 PST 1992 by kalsow         *)
(*      Modified On Fri Dec 21 00:53:14 1990 by muller         *)

INTERFACE TypeRep;

IMPORT M3, Type, String, MBuf;
IMPORT TrOffsets;

TYPE
  TT = M3.Type;

TYPE
  Class = { None, Array, Enum, Object, Opaque, OpenArray, Packed,
             Procedure, Record, Ref, Set, Subrange };

REVEAL
  M3.Type = M3.Node BRANDED "Type.T" OBJECT
    declared    : M3.Value;
    hash        : INTEGER;
    fp          : INTEGER;
    checked     : M3.Flag;
    isTraced    : M3.Flag;   (* contains a traced ref for non-refs *)
    hasUntraced : M3.Flag;
    isLocalOnly : M3.Flag;   (* contains proc or non-network ref *)
    imported    : M3.Flag;
    inCheck     : M3.Flag;
    inStrip     : M3.Flag;
    inDependsOn : M3.Flag;
    inSize      : M3.Flag;
    inMinSize   : M3.Flag;
    inAlignment : M3.Flag;
    inIsEmpty   : M3.Flag;
    inNumber    : M3.Flag;
    inGetBounds : M3.Flag;
    errored     : M3.Flag;
    next        : TT;
  METHODS
    check      ()                                     := MissingCheck;
    isEqual    (t: TT;  x: Type.Assumption): BOOLEAN  := MissingEqCheck;
    isSubtype  (t: TT): BOOLEAN                       := NoSubtypes;
    isNetworkType (): BOOLEAN                         := NotNetworkType;
    base       (): TT                                 := SelfBase;
    count      (): INTEGER                            := NotOrdinal;
    bounds     (VAR min, max: INTEGER): BOOLEAN       := NotBounded;
    size       (): INTEGER                            := MissingSize;
    minSize    (): INTEGER                            := MissingSize;
    alignment  (): INTEGER                            := MissingSize;
    isEmpty    (): BOOLEAN                            := MissingEmpty;
    dependsOn  (t: TT): BOOLEAN                       := MissingDepends;
    compile    ()                                     := MissingCompile;
    initCost   (zeroed: BOOLEAN): INTEGER             := MissingInitCost;
    initValue  ()                                     := MissingInitValue;
    mapper     (VAR prefix: String.Stack)             := NoMapper;
    tracedOffs (offset: CARDINAL): TrOffsets.T        := NotTraced;
    paramEncoding (): TEXT                            := WordEncoding;
    fprint     (map: Type.FPMap;  wr: MBuf.T)         := MissingFPrint;
    stripper   (): TT                                 := SelfBase;
    class      (): Class                              := MissingClass;
  END;

(* "default" methods to catch NIL procedure calls *)
(* == ASSERT FALSE *)
PROCEDURE MissingCheck (t: TT);
PROCEDURE MissingEqCheck (a, b: TT;  x: Type.Assumption): BOOLEAN;
PROCEDURE MissingSize (t: TT): INTEGER;
PROCEDURE MissingEmpty (t: TT): BOOLEAN;
PROCEDURE MissingDepends (a, b: TT): BOOLEAN;
PROCEDURE MissingCompile (t: TT);
PROCEDURE MissingInitCost (t: TT;  zeroed: BOOLEAN): INTEGER;
PROCEDURE MissingInitValue (t: TT);
PROCEDURE MissingFPrint (t: TT; map: Type.FPMap;  wr: MBuf.T);
PROCEDURE MissingClass (t: TT): Class;


PROCEDURE Init (t: TT);
(* initialize the shared fields of a Type.T *)

PROCEDURE IsCompiled (t: TT): BOOLEAN;
(* returns TRUE if t is marked "compiled" *)

PROCEDURE MarkCompiled (t: TT);
(* marks t "compiled" *)

PROCEDURE StartLinkInfo (t: TT): BOOLEAN;
(* switch to the LinkerTypes stream and emit t's header,
   returns TRUE if t doesn't need a full linker definition *)

PROCEDURE SelfBase (t: TT): TT;
(* == RETURN t *)

PROCEDURE NeverEqual (a, b: TT;  x: Type.Assumption): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE NoSubtypes (a, b: TT): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE NotNetworkType (t: TT): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE DependsOnNone (a, b: TT): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE NotOrdinal (t: TT): INTEGER;
(* == RETURN -1 *)

PROCEDURE IsNever (t: TT): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE IsAlways (t: TT): BOOLEAN;
(* == RETURN TRUE *)

PROCEDURE NotBounded (t: TT;  VAR min, max: INTEGER): BOOLEAN;
(* == RETURN FALSE *)

PROCEDURE NoMapper (t: TT;  VAR prefix: String.Stack);
(* == skip *)

PROCEDURE NotTraced (t: TT; offset: CARDINAL): TrOffsets.T;
(* == RETURN NIL *)

PROCEDURE WordEncoding (t: TT): TEXT;
(* == RETURN ParamCode.Word *)

PROCEDURE ParamEncUndefined (t: TT): TEXT;
(* == <* ASSERT FALSE *> *)

PROCEDURE GenRefMap (t: TT;  VAR prefix: String.Stack);
(* == IF MASK_{UN}TRACED(t) THEN p(t) *)

END TypeRep.
